/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.data.Converter;
import com.dua3.utility.lang.LangUtil;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class PropertyConverter {
    public static <A, B, P extends Property<A>> Property<B> convert(P property, Converter<A, B> converter) {
        if (property == null) {
            throw new IllegalArgumentException("property is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        LangUtil.check((!property.isBound() ? 1 : 0) != 0, (String)"property must not be bound!", (Object[])new Object[0]);
        SimpleObjectProperty convertedProperty = new SimpleObjectProperty(converter.convert(property.getValue()));
        property.addListener((arg_0, arg_1, arg_2) -> PropertyConverter.lambda$convert$0((Property)convertedProperty, converter, arg_0, arg_1, arg_2));
        convertedProperty.addListener((obs, oldValue, newValue) -> property.setValue(converter.convertBack(newValue)));
        return convertedProperty;
    }

    public static <A, B, V extends ObservableValue<A>> ReadOnlyProperty<B> convertReadOnly(V value, Converter<A, B> converter) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        return PropertyConverter.convertReadOnly(value, arg_0 -> converter.convert(arg_0));
    }

    public static <A, B, V extends ObservableValue<A>> ReadOnlyProperty<B> convertReadOnly(V value, Function<A, B> converter) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is null");
        }
        SimpleObjectProperty convertedProperty = new SimpleObjectProperty(converter.apply(value.getValue()));
        value.addListener((arg_0, arg_1, arg_2) -> PropertyConverter.lambda$convertReadOnly$2((Property)convertedProperty, converter, arg_0, arg_1, arg_2));
        return convertedProperty;
    }

    private static /* synthetic */ void lambda$convertReadOnly$2(Property convertedProperty, Function converter, ObservableValue obs, Object oldValue, Object newValue) {
        convertedProperty.setValue(converter.apply(newValue));
    }

    private static /* synthetic */ void lambda$convert$0(Property convertedProperty, Converter converter, ObservableValue obs, Object oldValue, Object newValue) {
        convertedProperty.setValue(converter.convert(newValue));
    }
}

