/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.fx;

import com.dua3.utility.lang.LangUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.control.Control;

public record ValidationResult(Control control, Level level, String message) {
    public ValidationResult {
        if (control == null) {
            throw new IllegalArgumentException("control is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
    }

    public static ValidationResult ok(Control c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        return new ValidationResult(c, Level.OK, "");
    }

    public static ValidationResult error(Control c, String message) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        return new ValidationResult(c, Level.ERROR, message);
    }

    public boolean isOk() {
        return this.level == Level.OK;
    }

    public ValidationResult merge(ValidationResult other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        LangUtil.check((other.control() == this.control() ? 1 : 0) != 0, (String)"trying to merge results for different controls", (Object[])new Object[0]);
        if (this.isOk()) {
            return other;
        }
        if (other.isOk()) {
            return this;
        }
        return new ValidationResult(this.control(), Level.ERROR, Stream.of(this.message(), other.message()).filter(s -> !s.isBlank()).collect(Collectors.joining("\n")));
    }

    public static enum Level {
        OK,
        ERROR;

    }
}

