/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.data.Color;
import com.dua3.utility.data.Pair;
import com.dua3.utility.io.AnsiCode;
import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryHandler;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.event.Level;

public class ConsoleHandler
implements LogEntryHandler {
    private static final String NEWLINE = "%n".formatted(new Object[0]);
    private static final Pair<String, String> NO_ESCAPE_SEQUENCES = Pair.of((Object)"", (Object)"");
    private static final String ESC_RESET = AnsiCode.reset();
    private final PrintStream out;
    private final Map<Level, Pair<String, String>> brackets = new EnumMap<Level, Pair<String, String>>(Level.class);

    public ConsoleHandler(PrintStream out, boolean colored) {
        assert (out != null) : "parameter 'out' must not be null";
        this.out = out;
        if (colored) {
            this.brackets.put(Level.TRACE, (Pair<String, String>)Pair.of((Object)AnsiCode.fg((Color)Color.DARKGRAY), (Object)ESC_RESET));
            this.brackets.put(Level.DEBUG, (Pair<String, String>)Pair.of((Object)AnsiCode.fg((Color)Color.BLACK), (Object)ESC_RESET));
            this.brackets.put(Level.INFO, (Pair<String, String>)Pair.of((Object)AnsiCode.fg((Color)Color.BLUE), (Object)ESC_RESET));
            this.brackets.put(Level.WARN, (Pair<String, String>)Pair.of((Object)AnsiCode.fg((Color)Color.ORANGERED), (Object)ESC_RESET));
            this.brackets.put(Level.ERROR, (Pair<String, String>)Pair.of((Object)AnsiCode.fg((Color)Color.DARKRED), (Object)ESC_RESET));
        }
    }

    @Override
    public void handleEntry(LogEntry entry) {
        assert (entry != null) : "parameter 'entry' must not be null";
        Pair<String, String> esc = this.brackets.getOrDefault(entry.level(), NO_ESCAPE_SEQUENCES);
        this.out.append((CharSequence)esc.first()).append(String.valueOf(entry)).append((CharSequence)esc.second()).append(NEWLINE);
    }
}

