/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.lang.RingBuffer;
import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LogBuffer
implements LogEntryHandler,
Externalizable {
    public static final int DEFAULT_CAPACITY = 10000;
    private final RingBuffer<LogEntry> buffer;
    private final Collection<LogBufferListener> listeners = new ArrayList<LogBufferListener>();

    public LogBuffer() {
        this(10000);
    }

    public LogBuffer(int capacity) {
        this.buffer = new RingBuffer(capacity);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (out != null) : "parameter 'out' must not be null";
        Object[] entries = this.buffer.toArray();
        out.write(entries.length);
        for (Object entry : entries) {
            out.writeObject(entry);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        assert (in != null) : "parameter 'in' must not be null";
        this.buffer.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.buffer.add((Object)((LogEntry)in.readObject()));
        }
    }

    public void addLogBufferListener(LogBufferListener listener) {
        assert (listener != null) : "parameter 'listener' must not be null";
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeLogBufferListener(LogBufferListener listener) {
        assert (listener != null) : "parameter 'listener' must not be null";
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEntry(LogEntry entry) {
        boolean replaced;
        assert (entry != null) : "parameter 'entry' must not be null";
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            int oldSize = this.buffer.size();
            this.buffer.add((Object)entry);
            replaced = this.buffer.size() == oldSize;
        }
        this.listeners.forEach(listener -> listener.entry(entry, replaced));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            this.buffer.clear();
        }
        this.listeners.forEach(LogBufferListener::clear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> entries() {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return List.of((LogEntry[])this.buffer.toArray(LogEntry[]::new));
        }
    }

    public LogEntry get(int i) {
        return (LogEntry)this.buffer.get(i);
    }

    public int size() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> subList(int fromIndex, int toIndex) {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return new ArrayList<LogEntry>(this.buffer.subList(fromIndex, toIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getLogEntries() {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return new ArrayList<LogEntry>((Collection<LogEntry>)this.buffer);
        }
    }

    public void appendTo(Appendable app) throws IOException {
        assert (app != null) : "parameter 'app' must not be null";
        for (LogEntry entry : this.getLogEntries()) {
            app.append(entry.toString()).append("\n");
        }
    }

    public static interface LogBufferListener {
        default public void entry(LogEntry entry, boolean replaced) {
            if (!1.$assertionsDisabled && entry == null) {
                throw new AssertionError((Object)"parameter 'entry' must not be null");
            }
            this.entries(Collections.singleton(entry), replaced ? 1 : 0);
        }

        public void entries(Collection<LogEntry> var1, int var2);

        public void clear();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

