/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public record LogEntry(Logger logger, Instant time, Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) implements Serializable
{
    public String formatMessage() {
        return MessageFormatter.basicArrayFormat((String)this.msg, (Object[])this.arguments);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String formatThrowable() {
        if (this.throwable == null) {
            return "";
        }
        try (StringWriter sw = new StringWriter(200);){
            PrintWriter pw = new PrintWriter(sw);
            try {
                this.throwable.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return this.throwable.toString();
        }
    }

    @Override
    public String toString() {
        if (this.throwable() == null) {
            return "[%-5s] %s %s\t%s".formatted(this.level, DateTimeFormatter.ISO_INSTANT.format(this.time), this.logger.getName(), this.formatMessage());
        }
        return "[%-5s] %s %s\t%s%n%s".formatted(this.level, DateTimeFormatter.ISO_INSTANT.format(this.time), this.logger.getName(), this.formatMessage(), this.formatThrowable());
    }
}

