/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryHandler;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;

public class Logger
extends AbstractLogger {
    private static Level defaultLevel = Level.INFO;
    private final List<? extends LogEntryHandler> handlers;
    private final Map<Marker, Level> markerLevelMap = new HashMap<Marker, Level>();
    private Level level;

    public Logger(String name, List<? extends LogEntryHandler> handlers) {
        assert (name != null) : "parameter 'name' must not be null";
        assert (handlers != null) : "parameter 'handlers' must not be null";
        this.name = name;
        this.handlers = handlers;
    }

    public static Level getDefaultLevel() {
        return defaultLevel;
    }

    public static void setDefaultLevel(Level level) {
        assert (level != null) : "parameter 'level' must not be null";
        defaultLevel = level;
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        assert (level != null) : "parameter 'level' must not be null";
        assert (messagePattern != null) : "parameter 'messagePattern' must not be null";
        this.handlers.forEach(handler -> handler.handleEntry(new LogEntry((org.slf4j.Logger)this, Instant.now(), level, marker, messagePattern, arguments, throwable)));
    }

    public boolean isTraceEnabled() {
        return this.getLevel().toInt() <= Level.TRACE.toInt();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.markerLevelMap.getOrDefault(marker, this.getLevel()).toInt() <= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.getLevel().toInt() <= Level.DEBUG.toInt();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.markerLevelMap.getOrDefault(marker, this.getLevel()).toInt() <= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.getLevel().toInt() <= Level.INFO.toInt();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.markerLevelMap.getOrDefault(marker, this.getLevel()).toInt() <= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.getLevel().toInt() <= Level.WARN.toInt();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.markerLevelMap.getOrDefault(marker, this.getLevel()).toInt() <= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.getLevel().toInt() <= Level.ERROR.toInt();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.markerLevelMap.getOrDefault(marker, this.getLevel()).toInt() <= Level.ERROR.toInt();
    }

    public Level getLevel() {
        return this.level != null ? this.level : defaultLevel;
    }

    public void setLevel(Level level) {
        assert (level != null) : "parameter 'level' must not be null";
        this.level = level;
    }
}

