/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.data.Pair;
import com.dua3.utility.lang.LangUtil;
import com.dua3.utility.logging.ConsoleHandler;
import com.dua3.utility.logging.LogBuffer;
import com.dua3.utility.logging.LogEntryHandler;
import com.dua3.utility.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.ILoggerFactory;
import org.slf4j.event.Level;

public class LoggerFactory
implements ILoggerFactory {
    public static final String LEVEL = "logger.level";
    public static final String LOGGER_CONSOLE_STREAM = "logger.console.stream";
    public static final String LOGGER_CONSOLE_COLORED = "logger.console.colored";
    public static final String LOGGER_BUFFER_SIZE = "logger.buffer.size";
    private final LogBuffer logBuffer;
    private final List<Pair<String, Level>> prefixes = new ArrayList<Pair<String, Level>>();
    private final List<LogEntryHandler> handlers = new ArrayList<LogEntryHandler>();

    public LoggerFactory() {
        String propertyBuffer;
        int bufferSize;
        String propertyConsoleColored;
        String propertyConsoleStream;
        Properties properties = LoggerFactory.getProperties();
        String leveldeclaration = properties.getProperty(LEVEL, Level.INFO.name());
        String[] decls = leveldeclaration.split(",");
        if (decls.length > 0) {
            Logger.setDefaultLevel(Level.valueOf((String)decls[0].strip()));
        }
        Arrays.stream(decls).skip(1L).forEachOrdered(s -> {
            String[] parts = s.split(":");
            LangUtil.check((parts.length == 2 ? 1 : 0) != 0, (String)"invalid log level declaration: %s", (Object[])new Object[]{s});
            String prefix = parts[0].strip();
            Level level = Level.valueOf((String)parts[1].strip());
            Optional<Pair<String, Level>> entry = this.getPrefixEntry(prefix);
            LangUtil.check((boolean)entry.isEmpty(), () -> new IllegalStateException("prefix '%s' is shadowed by '%s'".formatted(prefix, ((Pair)entry.orElseThrow()).first())));
            this.prefixes.add((Pair<String, Level>)Pair.of((Object)prefix, (Object)level));
        });
        PrintStream stream = switch (propertyConsoleStream = properties.getProperty(LOGGER_CONSOLE_STREAM, "").trim().toLowerCase(Locale.ROOT)) {
            case "" -> null;
            case "system.err" -> System.err;
            case "system.out" -> System.out;
            default -> throw new IllegalArgumentException("invalid value for property logger.console.stream: '" + propertyConsoleStream + "'");
        };
        boolean colored = switch (propertyConsoleColored = properties.getProperty(LOGGER_CONSOLE_COLORED, "auto").trim().toLowerCase(Locale.ROOT)) {
            case "true" -> true;
            case "false" -> false;
            case "auto" -> {
                if (System.console() != null && System.getenv().get("TERM") != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("invalid value for property logger.console.colored: '" + propertyConsoleColored + "'");
        };
        if (stream != null) {
            this.handlers.add(new ConsoleHandler(stream, colored));
        }
        if ((bufferSize = Integer.parseInt(propertyBuffer = properties.getProperty(LOGGER_BUFFER_SIZE, "0").trim())) > 0) {
            this.logBuffer = new LogBuffer(bufferSize);
            this.handlers.add(this.logBuffer);
        } else {
            this.logBuffer = null;
        }
    }

    private static Properties getProperties() {
        Properties properties = new Properties();
        try (InputStream in = ClassLoader.getSystemResourceAsStream("logging.properties");){
            if (in == null) {
                properties.setProperty(LOGGER_CONSOLE_STREAM, "system.out");
            } else {
                properties.load(in);
            }
        }
        catch (IOException e) {
            properties.setProperty(LOGGER_CONSOLE_STREAM, "system.out");
            e.printStackTrace(System.err);
        }
        return properties;
    }

    private Optional<Pair<String, Level>> getPrefixEntry(String name) {
        assert (name != null) : "parameter 'name' must not be null";
        return this.prefixes.stream().filter(p -> name.startsWith((String)p.first())).findFirst();
    }

    private Level getLevel(String name) {
        assert (name != null) : "parameter 'name' must not be null";
        return this.getPrefixEntry(name).map(Pair::second).orElseGet(Logger::getDefaultLevel);
    }

    public org.slf4j.Logger getLogger(String name) {
        assert (name != null) : "parameter 'name' must not be null";
        Logger logger = new Logger(name, this.handlers);
        logger.setLevel(this.getLevel(name));
        return logger;
    }

    public Optional<LogBuffer> getLogBuffer() {
        return Optional.ofNullable(this.logBuffer);
    }
}

