/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.data.Color;
import com.dua3.utility.data.Pair;
import com.dua3.utility.io.AnsiCode;
import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryFilter;
import com.dua3.utility.logging.LogEntryHandler;
import com.dua3.utility.logging.LogLevel;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.Map;

public final class ConsoleHandler
implements LogEntryHandler {
    private static final String NEWLINE = System.lineSeparator();
    private static final Map<LogLevel, Pair<String, String>> COLOR_MAP_COLORED = Map.of(LogLevel.TRACE, Pair.of((Object)AnsiCode.italic((boolean)true), (Object)(AnsiCode.reset() + NEWLINE)), LogLevel.DEBUG, Pair.of((Object)"", (Object)NEWLINE), LogLevel.INFO, Pair.of((Object)AnsiCode.bold((boolean)true), (Object)NEWLINE), LogLevel.WARN, Pair.of((Object)(AnsiCode.fg((Color)Color.ORANGERED) + AnsiCode.bold((boolean)true)), (Object)(AnsiCode.reset() + NEWLINE)), LogLevel.ERROR, Pair.of((Object)(AnsiCode.fg((Color)Color.DARKRED) + AnsiCode.bold((boolean)true)), (Object)(AnsiCode.reset() + NEWLINE)));
    private static final Map<LogLevel, Pair<String, String>> COLOR_MAP_MONOCHROME = Map.of(LogLevel.TRACE, Pair.of((Object)"", (Object)NEWLINE), LogLevel.DEBUG, Pair.of((Object)"", (Object)NEWLINE), LogLevel.INFO, Pair.of((Object)"", (Object)NEWLINE), LogLevel.WARN, Pair.of((Object)"", (Object)NEWLINE), LogLevel.ERROR, Pair.of((Object)"", (Object)NEWLINE));
    private final PrintStream out;
    private volatile LogEntryFilter filter;
    private volatile Map<LogLevel, Pair<String, String>> colorMap;

    public ConsoleHandler(PrintStream out, boolean colored) {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        this.filter = LogEntryFilter.allPass();
        this.colorMap = new EnumMap<LogLevel, Pair<String, String>>(LogLevel.class);
        this.out = out;
        this.setColored(colored);
    }

    @Override
    public void handleEntry(LogEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is null");
        }
        Pair<String, String> colors = this.colorMap.get((Object)entry.level());
        this.out.append(entry.format((String)colors.first(), (String)colors.second()));
    }

    public void setColored(boolean colored) {
        this.colorMap = colored ? COLOR_MAP_COLORED : COLOR_MAP_MONOCHROME;
    }

    public boolean isColored() {
        return this.colorMap == COLOR_MAP_COLORED;
    }

    public void setFilter(LogEntryFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        this.filter = filter;
    }

    public LogEntryFilter getFilter() {
        return this.filter;
    }
}

