/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryFilter;
import com.dua3.utility.logging.LogLevel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;

public class DefaultLogEntryFilter
implements LogEntryFilter {
    private final ConcurrentHashMap<String, Boolean> knownLoggers;
    private volatile LogLevel level;
    private volatile BiPredicate<String, LogLevel> filterLoggerName;
    private volatile BiPredicate<String, LogLevel> filterText;

    public DefaultLogEntryFilter() {
        this(LogLevel.TRACE, (name, level) -> true, (text, level) -> true);
    }

    public DefaultLogEntryFilter(LogLevel level, BiPredicate<String, LogLevel> filterLoggerName, BiPredicate<String, LogLevel> filterText) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (filterLoggerName == null) {
            throw new NullPointerException("filterLoggerName is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is null");
        }
        this.knownLoggers = new ConcurrentHashMap();
        this.level = level;
        this.filterLoggerName = filterLoggerName;
        this.filterText = filterText;
    }

    public void setLevel(LogLevel level) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        this.level = level;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setFilterLoggerName(BiPredicate<String, LogLevel> filterLoggerName) {
        if (filterLoggerName == null) {
            throw new NullPointerException("filterLoggerName is null");
        }
        if (this.filterLoggerName != filterLoggerName) {
            this.filterLoggerName = filterLoggerName;
            this.knownLoggers.clear();
        }
    }

    public BiPredicate<String, LogLevel> getFilterLoggerName() {
        return this.filterLoggerName;
    }

    public void setFilterText(BiPredicate<String, LogLevel> filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is null");
        }
        if (this.filterText != filterText) {
            this.filterText = filterText;
        }
    }

    public BiPredicate<String, LogLevel> getFilterText() {
        return this.filterText;
    }

    @Override
    public boolean test(LogEntry logEntry) {
        if (logEntry == null) {
            throw new NullPointerException("logEntry is null");
        }
        if (logEntry.level().ordinal() < this.level.ordinal()) {
            return false;
        }
        boolean isLoggerShown = this.knownLoggers.computeIfAbsent(logEntry.loggerName(), loggerName -> this.filterLoggerName.test(logEntry.loggerName(), logEntry.level()));
        if (!isLoggerShown) {
            return false;
        }
        return this.filterText.test(logEntry.message(), logEntry.level());
    }

    public DefaultLogEntryFilter copy() {
        return new DefaultLogEntryFilter(this.getLevel(), this.getFilterLoggerName(), this.getFilterText());
    }

    public DefaultLogEntryFilter withLevel(LogLevel newLevel) {
        if (newLevel == null) {
            throw new NullPointerException("newLevel is null");
        }
        return new DefaultLogEntryFilter(newLevel, this.getFilterLoggerName(), this.getFilterText());
    }

    public DefaultLogEntryFilter withFilterLoggerName(BiPredicate<String, LogLevel> newFilter) {
        if (newFilter == null) {
            throw new NullPointerException("newFilter is null");
        }
        return new DefaultLogEntryFilter(this.getLevel(), newFilter, this.getFilterText());
    }

    public DefaultLogEntryFilter withFilterText(BiPredicate<String, LogLevel> newFilter) {
        if (newFilter == null) {
            throw new NullPointerException("newFilter is null");
        }
        return new DefaultLogEntryFilter(this.getLevel(), this.getFilterLoggerName(), newFilter);
    }
}

