/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.lang.RingBuffer;
import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogBuffer
implements LogEntryHandler,
Externalizable {
    public static final int DEFAULT_CAPACITY = 10000;
    private final RingBuffer<LogEntry> buffer;
    private final Collection<LogBufferListener> listeners = new ArrayList<LogBufferListener>();

    public LogBuffer() {
        this(10000);
    }

    public LogBuffer(int capacity) {
        this.buffer = new RingBuffer(capacity);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        Object[] entries = this.buffer.toArray();
        out.write(entries.length);
        for (Object entry : entries) {
            out.writeObject(entry);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in == null) {
            throw new NullPointerException("in is null");
        }
        this.buffer.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.buffer.add((Object)((LogEntry)in.readObject()));
        }
    }

    public void addLogBufferListener(LogBufferListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeLogBufferListener(LogBufferListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEntry(LogEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is null");
        }
        Collection<LogBufferListener> collection = this.listeners;
        synchronized (collection) {
            int removed;
            RingBuffer<LogEntry> ringBuffer = this.buffer;
            synchronized (ringBuffer) {
                removed = this.buffer.put((Object)entry) ? 0 : 1;
            }
            this.listeners.forEach(listener -> listener.entries(removed, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Collection<LogBufferListener> collection = this.listeners;
        synchronized (collection) {
            RingBuffer<LogEntry> ringBuffer = this.buffer;
            synchronized (ringBuffer) {
                this.buffer.clear();
            }
            this.listeners.forEach(LogBufferListener::clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry[] toArray() {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return (LogEntry[])this.buffer.toArray(LogEntry[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry get(int i) {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return (LogEntry)this.buffer.get(i);
        }
    }

    public int size() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> subList(int fromIndex, int toIndex) {
        RingBuffer<LogEntry> ringBuffer = this.buffer;
        synchronized (ringBuffer) {
            return new ArrayList<LogEntry>(this.buffer.subList(fromIndex, toIndex));
        }
    }

    public void appendTo(Appendable app) throws IOException {
        if (app == null) {
            throw new NullPointerException("app is null");
        }
        for (LogEntry entry : this.toArray()) {
            app.append(entry.toString()).append("\n");
        }
    }

    public static interface LogBufferListener {
        public void entries(int var1, int var2);

        public void clear();
    }
}

