/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.logging.LogLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public interface LogEntry {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public String message();

    public String loggerName();

    public Instant time();

    public LogLevel level();

    public String marker();

    public Throwable throwable();

    default public String format(String prefix, String suffix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is null");
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(prefix);
        sb.append('[').append((Object)this.level()).append(']');
        sb.append(' ');
        sb.append(DateTimeFormatter.ISO_INSTANT.format(this.time()));
        sb.append(' ');
        sb.append(this.loggerName());
        sb.append(' ');
        sb.append(this.message());
        if (this.throwable() != null) {
            sb.append(System.lineSeparator());
            this.appendThrowable(sb);
        }
        sb.append(suffix);
        return sb.toString();
    }

    private void appendThrowable(StringBuilder sb) {
        assert (sb != null) : "sb is null";
        Throwable t = this.throwable();
        if (t == null) {
            sb.append("null");
        } else {
            try (StringWriter sw = new StringWriter(200);
                 PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                sb.append(sw);
            }
            catch (IOException e) {
                sb.append(t);
            }
        }
    }
}

