/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.logging.ILogEntryDispatcherFactory;
import com.dua3.utility.logging.LogEntryDispatcher;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LogUtil {
    private static final Logger LOG = LogManager.getLogger(LogUtil.class);
    private static LogEntryDispatcher globalDispatcher;

    private LogUtil() {
    }

    private static synchronized void init() {
        if (globalDispatcher == null) {
            ServiceLoader<ILogEntryDispatcherFactory> serviceLoader = ServiceLoader.load(ILogEntryDispatcherFactory.class);
            for (ILogEntryDispatcherFactory factory : serviceLoader) {
                try {
                    LogEntryDispatcher dispatcher = factory.getDispatcher();
                    if (dispatcher != null) {
                        LOG.debug("created dispatcher of class {} using factory {}", dispatcher.getClass(), factory.getClass());
                        globalDispatcher = dispatcher;
                        return;
                    }
                    LOG.debug("factory {} did not return a dispatcher", factory.getClass());
                }
                catch (Exception e) {
                    LOG.warn("factory {} threw an exception when trying to create a dispatcher", (Object)factory.getClass().getName(), (Object)e);
                }
            }
            throw new ServiceConfigurationError("no factories left to try - could not create a dispatcher");
        }
    }

    public static void assureInitialized() {
        if (globalDispatcher == null) {
            LogUtil.init();
        }
    }

    public static LogEntryDispatcher getGlobalDispatcher() {
        LogUtil.assureInitialized();
        return globalDispatcher;
    }
}

