/*
 * Decompiled with CFR 0.152.
 */
package com.dua3.utility.logging;

import com.dua3.utility.logging.LogEntry;
import com.dua3.utility.logging.LogEntryFilter;
import com.dua3.utility.logging.LogLevel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;

public class DefaultLogEntryFilter
implements LogEntryFilter {
    private final ConcurrentHashMap<String, Boolean> knownLoggers;
    private volatile LogLevel level;
    private volatile BiPredicate<String, LogLevel> filter;

    public DefaultLogEntryFilter() {
        this(LogLevel.TRACE, (name, level) -> true);
    }

    public DefaultLogEntryFilter(LogLevel level, BiPredicate<String, LogLevel> filter) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        this.knownLoggers = new ConcurrentHashMap();
        this.level = level;
        this.filter = filter;
    }

    public void setLevel(LogLevel level) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        this.level = level;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setFilter(BiPredicate<String, LogLevel> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        if (this.filter != filter) {
            this.filter = filter;
            this.knownLoggers.clear();
        }
    }

    public BiPredicate<String, LogLevel> getFilter() {
        return this.filter;
    }

    @Override
    public boolean test(LogEntry logEntry) {
        if (logEntry == null) {
            throw new NullPointerException("logEntry is null");
        }
        if (logEntry.level().ordinal() < this.level.ordinal()) {
            return false;
        }
        return this.knownLoggers.computeIfAbsent(logEntry.loggerName(), loggerName -> this.filter.test(logEntry.loggerName(), logEntry.level()));
    }

    public DefaultLogEntryFilter copy() {
        return new DefaultLogEntryFilter(this.getLevel(), this.getFilter());
    }

    public DefaultLogEntryFilter withLevel(LogLevel newLevel) {
        if (newLevel == null) {
            throw new NullPointerException("newLevel is null");
        }
        return new DefaultLogEntryFilter(newLevel, this.getFilter());
    }

    public DefaultLogEntryFilter withFilter(BiPredicate<String, LogLevel> newFilter) {
        if (newFilter == null) {
            throw new NullPointerException("newFilter is null");
        }
        return new DefaultLogEntryFilter(this.getLevel(), newFilter);
    }
}

