/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedExceptionMatcherBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ExpectedException
implements TestRule {
    private final ExpectedExceptionMatcherBuilder matcherBuilder = new ExpectedExceptionMatcherBuilder();
    private String missingExceptionMessage = "Expected test to throw %s";

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    @Deprecated
    public ExpectedException handleAssertionErrors() {
        return this;
    }

    @Deprecated
    public ExpectedException handleAssumptionViolatedExceptions() {
        return this;
    }

    public ExpectedException reportMissingExceptionWithMessage(String message) {
        this.missingExceptionMessage = message;
        return this;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return new ExpectedExceptionStatement(base);
    }

    @Deprecated
    public ExpectedException expect(Matcher<?> matcher) {
        this.matcherBuilder.add(matcher);
        return this;
    }

    public ExpectedException expect(Class<? extends Throwable> type) {
        this.expect(CoreMatchers.instanceOf(type));
        return this;
    }

    public ExpectedException expectMessage(String substring) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)substring));
        return this;
    }

    @Deprecated
    public ExpectedException expectMessage(Matcher<String> matcher) {
        this.expect(ThrowableMessageMatcher.hasMessage(matcher));
        return this;
    }

    @Deprecated
    public ExpectedException expectCause(Matcher<? extends Throwable> expectedCause) {
        this.expect(ThrowableCauseMatcher.hasCause(expectedCause));
        return this;
    }

    private void handleException(Throwable e) throws Throwable {
        if (!this.isAnyExceptionExpected()) {
            throw e;
        }
        Assert.assertThat(e, this.matcherBuilder.build());
    }

    private boolean isAnyExceptionExpected() {
        return this.matcherBuilder.expectsThrowable();
    }

    private void failDueToMissingException() throws AssertionError {
        Assert.fail(this.missingExceptionMessage());
    }

    private String missingExceptionMessage() {
        String expectation = StringDescription.toString(this.matcherBuilder.build());
        return String.format(this.missingExceptionMessage, expectation);
    }

    private class ExpectedExceptionStatement
    extends Statement {
        private final Statement next;

        public ExpectedExceptionStatement(Statement base) {
            this.next = base;
        }

        @Override
        public void evaluate() throws Throwable {
            try {
                this.next.evaluate();
            }
            catch (Throwable e) {
                ExpectedException.this.handleException(e);
                return;
            }
            if (ExpectedException.this.isAnyExceptionExpected()) {
                ExpectedException.this.failDueToMissingException();
            }
        }
    }
}

