/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public class Kinds {
    private Kinds() {
    }

    public static KindName kindName(MemberReferenceTree.ReferenceMode mode) {
        switch (mode) {
            case INVOKE: {
                return KindName.METHOD;
            }
            case NEW: {
                return KindName.CONSTRUCTOR;
            }
        }
        throw new AssertionError((Object)("Unexpected mode: " + (Object)((Object)mode)));
    }

    public static KindName kindName(Symbol sym) {
        switch (sym.getKind()) {
            case PACKAGE: {
                return KindName.PACKAGE;
            }
            case ENUM: {
                return KindName.ENUM;
            }
            case ANNOTATION_TYPE: 
            case CLASS: {
                return KindName.CLASS;
            }
            case RECORD: {
                return KindName.RECORD;
            }
            case INTERFACE: {
                return KindName.INTERFACE;
            }
            case TYPE_PARAMETER: {
                return KindName.TYPEVAR;
            }
            case BINDING_VARIABLE: 
            case ENUM_CONSTANT: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return KindName.VAR;
            }
            case FIELD: {
                return (sym.flags_field & 0x2000000000000000L) != 0L ? KindName.RECORD_COMPONENT : KindName.VAR;
            }
            case CONSTRUCTOR: {
                return KindName.CONSTRUCTOR;
            }
            case METHOD: {
                return KindName.METHOD;
            }
            case STATIC_INIT: {
                return KindName.STATIC_INIT;
            }
            case INSTANCE_INIT: {
                return KindName.INSTANCE_INIT;
            }
        }
        throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)sym.getKind())));
    }

    public static KindName typeKindName(Type t) {
        if (t.hasTag(TypeTag.TYPEVAR) || t.hasTag(TypeTag.CLASS) && (t.tsym.flags() & 0x1000000L) != 0L) {
            return KindName.BOUND;
        }
        if (t.hasTag(TypeTag.PACKAGE)) {
            return KindName.PACKAGE;
        }
        if ((t.tsym.flags_field & 0x2000L) != 0L) {
            return KindName.ANNOTATION;
        }
        if ((t.tsym.flags_field & 0x200L) != 0L) {
            return KindName.INTERFACE;
        }
        return KindName.CLASS;
    }

    public static enum KindName implements Formattable
    {
        ANNOTATION("kindname.annotation"),
        CONSTRUCTOR("kindname.constructor"),
        INTERFACE("kindname.interface"),
        ENUM("kindname.enum"),
        STATIC("kindname.static"),
        TYPEVAR("kindname.type.variable"),
        BOUND("kindname.type.variable.bound"),
        VAR("kindname.variable"),
        VAL("kindname.value"),
        METHOD("kindname.method"),
        CLASS("kindname.class"),
        STATIC_INIT("kindname.static.init"),
        INSTANCE_INIT("kindname.instance.init"),
        PACKAGE("kindname.package"),
        MODULE("kindname.module"),
        RECORD_COMPONENT("kindname.record.component"),
        RECORD("kindname.record"),
        ERROR("kindname.error");

        private final String name;

        private KindName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getKind() {
            return "Kindname";
        }

        @Override
        public String toString(Locale locale, Messages messages) {
            String s = this.toString();
            return messages.getLocalizedString(locale, "compiler.misc." + s, new Object[0]);
        }
    }

    public static class KindSelector {
        public static final KindSelector NIL = new KindSelector(0);
        public static final KindSelector PCK = new KindSelector(1);
        public static final KindSelector TYP = new KindSelector(2);
        public static final KindSelector VAR = new KindSelector(4);
        public static final KindSelector VAL = new KindSelector(12);
        public static final KindSelector MTH = new KindSelector(16);
        public static final KindSelector POLY = new KindSelector(32);
        public static final KindSelector MDL = new KindSelector(64);
        public static final KindSelector ERR = new KindSelector(127);
        public static final KindSelector ASG = new KindSelector(132);
        public static final KindSelector TYP_PCK = KindSelector.of(TYP, PCK);
        public static final KindSelector VAL_MTH = KindSelector.of(VAL, MTH);
        public static final KindSelector VAL_POLY = KindSelector.of(VAL, POLY);
        public static final KindSelector VAL_TYP = KindSelector.of(VAL, TYP);
        public static final KindSelector VAL_TYP_PCK = KindSelector.of(VAL, TYP, PCK);
        private final byte data;

        private KindSelector(int data) {
            this.data = (byte)data;
        }

        public static KindSelector of(KindSelector ... kindSelectors) {
            int newData = 0;
            for (KindSelector kindSel : kindSelectors) {
                newData = (byte)(newData | kindSel.data);
            }
            return new KindSelector(newData);
        }

        public boolean subset(KindSelector other) {
            return (this.data & ~other.data) == 0;
        }

        public boolean contains(KindSelector other) {
            return (this.data & other.data) != 0;
        }

        public Set<KindName> kindNames() {
            EnumSet<KindName> kinds = EnumSet.noneOf(KindName.class);
            if ((this.data & KindSelector.VAL.data) != 0) {
                if ((this.data & KindSelector.VAL.data) == KindSelector.VAR.data) {
                    kinds.add(KindName.VAR);
                } else {
                    kinds.add(KindName.VAL);
                }
            }
            if ((this.data & KindSelector.MTH.data) != 0) {
                kinds.add(KindName.METHOD);
            }
            if ((this.data & KindSelector.TYP.data) != 0) {
                kinds.add(KindName.CLASS);
            }
            if ((this.data & KindSelector.PCK.data) != 0) {
                kinds.add(KindName.PACKAGE);
            }
            if ((this.data & KindSelector.MDL.data) != 0) {
                kinds.add(KindName.MODULE);
            }
            return kinds;
        }
    }

    public static enum Kind {
        NIL(Category.BASIC, KindSelector.NIL),
        PCK(Category.BASIC, KindName.PACKAGE, KindSelector.PCK),
        TYP(Category.BASIC, KindName.CLASS, KindSelector.TYP),
        VAR(Category.BASIC, KindName.VAR, KindSelector.VAR),
        MTH(Category.BASIC, KindName.METHOD, KindSelector.MTH),
        POLY(Category.BASIC, KindSelector.POLY),
        MDL(Category.BASIC, KindSelector.MDL),
        ERR(Category.ERROR, KindSelector.ERR),
        AMBIGUOUS(Category.RESOLUTION_TARGET),
        HIDDEN(Category.RESOLUTION_TARGET),
        STATICERR(Category.RESOLUTION_TARGET),
        MISSING_ENCL(Category.RESOLUTION),
        BAD_RESTRICTED_TYPE(Category.RESOLUTION),
        ABSENT_VAR(Category.RESOLUTION_TARGET, KindName.VAR),
        WRONG_MTHS(Category.RESOLUTION_TARGET, KindName.METHOD),
        WRONG_MTH(Category.RESOLUTION_TARGET, KindName.METHOD),
        ABSENT_MTH(Category.RESOLUTION_TARGET, KindName.METHOD),
        ABSENT_TYP(Category.RESOLUTION_TARGET, KindName.CLASS);

        private final KindName kindName;
        private final KindName absentKind;
        private final KindSelector selector;
        private final Category category;

        private Kind(Category category) {
            this(category, null, null, null);
        }

        private Kind(Category category, KindSelector selector) {
            this(category, null, null, selector);
        }

        private Kind(Category category, KindName absentKind) {
            this(category, null, absentKind, null);
        }

        private Kind(Category category, KindName kindName, KindSelector selector) {
            this(category, kindName, null, selector);
        }

        private Kind(Category category, KindName kindName, KindName absentKind, KindSelector selector) {
            this.category = category;
            this.kindName = kindName;
            this.absentKind = absentKind;
            this.selector = selector;
        }

        public KindSelector toSelector() {
            return this.selector;
        }

        public boolean matches(KindSelector kindSelectors) {
            return this.selector.contains(kindSelectors);
        }

        public boolean isResolutionError() {
            return this.category == Category.RESOLUTION || this.category == Category.RESOLUTION_TARGET;
        }

        public boolean isResolutionTargetError() {
            return this.category == Category.RESOLUTION_TARGET;
        }

        public boolean isValid() {
            return this.category == Category.BASIC;
        }

        public boolean betterThan(Kind other) {
            return this.ordinal() < other.ordinal();
        }

        public KindName kindName() {
            if (this.kindName == null) {
                throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this)));
            }
            return this.kindName;
        }

        public KindName absentKind() {
            if (this.absentKind == null) {
                throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this)));
            }
            return this.absentKind;
        }

        private static enum Category {
            BASIC,
            ERROR,
            RESOLUTION,
            RESOLUTION_TARGET;

        }
    }
}

