/*
 *  Copyright 2004 Clinton Begin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.ibatis.sqlmap.engine.type;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * BigDecimal implementation of TypeHandler
 */
public class BigDecimalTypeHandler extends BaseTypeHandler<BigDecimal> {

    public void setParameter(PreparedStatement ps, int i, BigDecimal parameter, String jdbcType) throws SQLException {
        ps.setBigDecimal(i, parameter);
    }

    public BigDecimal getResult(ResultSet rs, String columnName) throws SQLException {
        BigDecimal bigdec = rs.getBigDecimal(columnName);
        if (rs.wasNull()) {
            return null;
        } else {
            return bigdec;
        }
    }

    public BigDecimal getResult(ResultSet rs, int columnIndex) throws SQLException {
        BigDecimal bigdec = rs.getBigDecimal(columnIndex);
        if (rs.wasNull()) {
            return null;
        } else {
            return bigdec;
        }
    }

    public BigDecimal getResult(CallableStatement cs, int columnIndex) throws SQLException {
        BigDecimal bigdec = cs.getBigDecimal(columnIndex);
        if (cs.wasNull()) {
            return null;
        } else {
            return bigdec;
        }
    }

    public BigDecimal valueOf(Object s) {
        if (s == null) {
            return null;
        } else if (s instanceof Boolean) {
            return Boolean.TRUE.equals(s) ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return new BigDecimal(s.toString());
    }

}
