/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common;

import com.ibatis.common.ArraySet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ArrayMap
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -1L;
    Object[] array;

    public ArrayMap(Object ... args) {
        this.array = args;
    }

    @Override
    public int size() {
        if (this.array != null) {
            return this.array.length;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.array == null || this.array.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            int idx = this.toIndex((String)key);
            return this.array != null && idx >= 0 && idx < this.array.length;
        }
        return false;
    }

    int toIndex(String key) {
        if (key != null) {
            char i;
            if (key.length() == 1 && (i = key.charAt(0)) <= '9') {
                return i - 49;
            }
            try {
                return Integer.parseInt(key) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.array != null) {
            for (Object o : this.array) {
                if (o == value) {
                    return true;
                }
                if (o == null || !o.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            int idx = this.toIndex((String)key);
            if (this.array != null && idx >= 0 && idx < this.array.length) {
                return this.array[idx];
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        int idx = this.toIndex(key);
        if (this.array != null && idx >= 0 && idx < this.array.length) {
            Object old = this.array[idx];
            this.array[idx] = value;
            return old;
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            return this.put((String)key, (Object)null);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m != null) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string));
            }
        }
    }

    @Override
    public void clear() {
        this.array = null;
    }

    @Override
    public Set<String> keySet() {
        if (this.array == null) {
            return Collections.emptySet();
        }
        ArraySet<String> set = new ArraySet<String>();
        for (int i = 0; i < this.array.length; ++i) {
            set.add(String.valueOf(i + 1));
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Collection<Object> values() {
        if (this.array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.array);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.array == null) {
            return Collections.emptySet();
        }
        ArraySet<MapEntry> set = new ArraySet<MapEntry>();
        for (int i = 0; i < this.array.length; ++i) {
            set.add(new MapEntry(String.valueOf(i + 1), this.array[i]));
        }
        return Collections.unmodifiableSet(set);
    }

    static class MapEntry
    implements Map.Entry<String, Object> {
        String key;
        Object val;

        public MapEntry(String key, Object val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public Object setValue(Object value) {
            Object val = this.val;
            this.val = value;
            return val;
        }
    }
}

