/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public final class Objects {
    final Object[] array;

    Objects(Object ... args) {
        this.array = args;
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.array != null) {
            for (Object o : this.array) {
                hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            }
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Objects) {
            Objects os = (Objects)o;
            if (this.array == os.array) {
                return true;
            }
            if (this.array == null || os.array == null) {
                return false;
            }
            if (this.array.length != os.array.length) {
                return false;
            }
            for (int i = this.array.length - 1; i > 0; --i) {
                Object o1 = this.array[i];
                Object o2 = os.array[i];
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> T uncheckedCast(Object obj) {
        return (T)obj;
    }

    public static Object getKey(Object ... args) {
        return new Objects(args);
    }

    public static int indexOf(StringBuilder buf, char delim, int from) {
        boolean inQuote = false;
        for (int i = from; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (inQuote) {
                if (c != '\'') continue;
                inQuote = false;
                continue;
            }
            if (c == delim) {
                return i;
            }
            if (c != '\'') continue;
            inQuote = true;
        }
        return -1;
    }

    public static void outputDate(Appendable a, Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(d.getTime());
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        try {
            a.append('\'');
            Objects.padInt(year, 4, a);
            a.append('-');
            Objects.padInt(month, 2, a);
            a.append('-');
            Objects.padInt(day, 2, a);
            a.append(' ');
            Objects.padInt(hour, 2, a);
            a.append(':');
            Objects.padInt(minute, 2, a);
            a.append(':');
            Objects.padInt(second, 2, a);
            a.append('\'');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void padInt(int val, int width, Appendable buf) throws IOException {
        String s;
        if (val < 0) {
            val = 0;
        }
        if ((s = Integer.toString(val)).length() > width) {
            s = s.substring(s.length() - width);
        }
        for (int j = width - s.length(); j > 0; --j) {
            buf.append('0');
        }
        buf.append(s);
    }
}

