/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common;

import com.ibatis.common.Objects;
import com.ibatis.common.Statsable;
import com.ibatis.common.Touchable;
import com.ibatis.common.jdbc.SimpleDataSource;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.ibatis.cglib.ReflectUtil;

public final class RunStats
implements Runnable {
    private static final ILog log = ILogFactory.getLog(RunStats.class);
    static RunStats INSTANCE;
    private final List<Statsable> stats = new ArrayList<Statsable>();
    private final List<Touchable> touchs = new ArrayList<Touchable>();
    private File statusFile;
    private final long initialTime = System.currentTimeMillis();
    volatile long lastFileTime;

    public static synchronized RunStats getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RunStats();
            Thread t = new Thread((Runnable)INSTANCE, "iBATIS RunStats");
            t.setDaemon(true);
            t.start();
        }
        return INSTANCE;
    }

    private RunStats() {
        String rsf;
        Properties p = Resources.getIbatisIniProperties();
        log.info("iBATIS ini -> " + p);
        String rcs = p.getProperty("cglib_cache_size");
        if (rcs != null && !rcs.trim().isEmpty()) {
            ReflectUtil.setCatchSize(rcs);
        }
        if ((rsf = p.getProperty("run_stats_file")) != null && rsf.length() > 0) {
            this.statusFile = new File(rsf);
        }
        Thread t = new Thread("iBATIS Cleaner"){

            @Override
            public void run() {
                RunStats.this.statusFile = null;
                String header = RunStats.this.getRunStatsHeader();
                try {
                    log.debug(header);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (Statsable stat : RunStats.this.stats) {
                    if (!(stat instanceof SimpleDataSource)) continue;
                    try {
                        ((SimpleDataSource)stat).forceCloseAll();
                    }
                    catch (Throwable throwable) {}
                }
                for (Statsable stat : RunStats.this.stats) {
                    if (stat instanceof SimpleDataSource) continue;
                    try {
                        log.info(stat.getStatus("iBATIS ! "));
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
        this.lastFileTime = RunStats.fileStamp(this.statusFile);
    }

    public void addTouchable(Touchable touch) {
        if (!this.touchs.contains(touch)) {
            this.touchs.add(touch);
        }
    }

    public void addStat(Statsable stat) {
        if (!this.stats.contains(stat)) {
            this.stats.add(stat);
            log.info(stat.getClass().getSimpleName() + " " + stat.hashCode() + " running...");
            log.info(stat.getStatus("iBATIS = "));
        }
    }

    @Override
    public void run() {
        int freq = 1;
        while (true) {
            try {
                while (true) {
                    Object header;
                    Thread.sleep(30000L);
                    freq %= 600;
                    if (this.checkFileTime()) {
                        for (Touchable touchable : this.touchs) {
                            try {
                                touchable.onTouch(this.statusFile);
                            }
                            catch (Exception exception) {}
                        }
                        header = this.getRunStatsHeader();
                        log.info((String)header);
                        System.out.println((String)header);
                        for (Statsable stat : this.stats) {
                            String s = stat.getStatus("iBATIS - ");
                            log.info(s);
                            System.out.println(s);
                        }
                    } else if (freq == 0 && log.isDebugEnabled()) {
                        header = this.getRunStatsHeader();
                        log.debug((String)header);
                        for (Statsable stat : this.stats) {
                            log.debug(stat.getStatus("iBATIS = "));
                        }
                    } else if (freq % 10 == 0 && log.isTraceEnabled()) {
                        for (Statsable statsable : this.stats) {
                            log.trace(statsable.getStatus("iBATIS - "));
                        }
                    }
                    ++freq;
                }
            }
            catch (Throwable t) {
                log.error("iBATIS RunStats error: " + t.getMessage(), t);
                continue;
            }
            break;
        }
    }

    String getRunStatsHeader() {
        StringBuilder buf = new StringBuilder("iBATIS run stats from ");
        Objects.outputDate(buf, new Date(this.initialTime));
        buf.append(" to ");
        Objects.outputDate(buf, new Date());
        return buf.toString();
    }

    static long fileStamp(File file) {
        if (file != null && file.isFile()) {
            long t = file.lastModified() / 1000L;
            if (file.canExecute()) {
                t = -t;
            }
            return t;
        }
        return 0L;
    }

    boolean checkFileTime() {
        long t = RunStats.fileStamp(this.statusFile);
        if (this.lastFileTime != t) {
            this.lastFileTime = t;
            return this.statusFile != null;
        }
        return false;
    }
}

