/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common;

public class StringTokenizer {
    private int currPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    final char delim;
    boolean skipSpace;
    char eq;

    public StringTokenizer(String str, char delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str, char delim, boolean skipSpace) {
        this(str, delim, '\u0000', skipSpace);
    }

    public StringTokenizer(String str, char delim, char eq, boolean skipSpace) {
        this.str = str;
        this.maxPosition = str.length();
        this.delim = delim;
        this.eq = eq;
        this.skipSpace = skipSpace;
    }

    int skipDelimiters(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && ((c = this.str.charAt(position)) == this.delim || this.eq != '\u0000' && c == this.eq || this.skipSpace && c == ' '); ++position) {
        }
        return position;
    }

    int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; !(position >= this.maxPosition || (c = this.str.charAt(position)) == this.delim || this.eq > '\u0000' && c == this.eq || this.skipSpace && c == ' '); ++position) {
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currPosition = this.newPosition >= 0 ? this.newPosition : this.skipDelimiters(this.currPosition);
        this.newPosition = -1;
        if (this.currPosition >= this.maxPosition) {
            throw new IllegalStateException();
        }
        int start = this.currPosition;
        this.currPosition = this.scanToken(this.currPosition);
        return this.str.substring(start, this.currPosition);
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

