/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.RunStats;
import com.ibatis.common.Statsable;
import com.ibatis.common.jdbc.SimplePooledConnection;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SimpleDataSource
implements DataSource,
Statsable {
    private static final ILog log = ILogFactory.getLog(SimpleDataSource.class);
    private static final String PROP_JDBC_DRIVER = "JDBC.Driver";
    private static final String PROP_JDBC_URL = "JDBC.ConnectionURL";
    private static final String PROP_JDBC_USERNAME = "JDBC.Username";
    private static final String PROP_JDBC_PASSWORD = "JDBC.Password";
    private static final String PROP_JDBC_DEFAULT_AUTOCOMMIT = "JDBC.DefaultAutoCommit";
    private static final String PROP_JDBC_DEFAULT_TRANSACTIONISOLATION = "JDBC.DefaultTransactionIsolation";
    private static final String PROP_POOL_MAX_ACTIVE_CONN = "Pool.MaximumActiveConnections";
    private static final String PROP_POOL_MAX_IDLE_CONN = "Pool.MaximumIdleConnections";
    private static final String PROP_POOL_MAX_CHECKOUT_TIME = "Pool.MaximumCheckoutTime";
    private static final String PROP_POOL_TIME_TO_WAIT = "Pool.TimeToWait";
    private static final String PROP_POOL_PING_QUERY = "Pool.PingQuery";
    private static final String PROP_POOL_PING_CONN_OLDER_THAN = "Pool.PingConnectionsOlderThan";
    private static final String PROP_POOL_PING_ENABLED = "Pool.PingEnabled";
    private static final String PROP_POOL_PING_CONN_NOT_USED_FOR = "Pool.PingConnectionsNotUsedFor";
    private static final String PROP_POOL_PING_IDLE_CONN_AFTER = "Pool.PingIdleConnectionsAfter";
    private static final String PROP_POOL_Erase_IDLE_CONN_AFTER = "Pool.EraseIdleConnectionsAfter";
    private static final String PROP_POOL_ShutdownDelay = "Pool.ShutdownDelay";
    private static final String PROP_POOL_LogSqlOverdueThan = "Pool.LogSqlOverdueThan";
    private static final String PROP_POOL_CommitOnReturn = "Pool.CommitOnReturn";
    private static final String ADD_DRIVER_PROPS_PREFIX = "Driver.";
    private static final int ADD_DRIVER_PROPS_PREFIX_LENGTH = "Driver.".length();
    private Que<SimplePooledConnection> idleConnections = new Que();
    private Que<SimplePooledConnection> activeConnections = new Que();
    private final Stat stat = new Stat();
    final ReentrantLock poolLock = new ReentrantLock();
    final Condition forIdle = this.poolLock.newCondition();
    long maxIdleCount = 0L;
    long maxActiveCount = 0L;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUsername;
    private String jdbcPassword;
    private Boolean jdbcDefaultAutoCommit;
    protected Integer defaultTransactionIsolation;
    private Properties driverProps;
    private String driverProperties;
    private boolean useDriverProps;
    private int poolMaxActive;
    private int poolMaxIdle;
    private int poolMaxCheckoutTime;
    private int poolTimeToWait;
    private String poolPingQuery;
    private String realPingQuery;
    private boolean poolPingEnabled;
    private int poolPingConnOlderThan;
    private int poolPingConnNotUsedFor;
    private int poolPingIdleConnAfter;
    private int poolEraseIdleConnAfter;
    private int poolShutdownDelay;
    int poolLogSqlOverdueThan;
    private boolean poolCommitOnReturn;
    int sql_executor_threshold;
    IdleThread idle;
    AtomicBoolean threadDumped = new AtomicBoolean(false);
    static final String SP16 = "                ";

    public SimpleDataSource(Map<Object, Object> props) {
        Properties p;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (props != null) {
            map.putAll(props);
        }
        if ((p = Resources.getIbatisIniProperties()) != null) {
            map.putAll(p);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("SimpleDataSource: The properties map passed to the initializer was empty.");
        }
        try {
            this.initialize(map);
        }
        catch (RuntimeException e) {
            log.error("SimpleDataSource: Error while loading properties. Cause: " + e.toString(), e);
            throw e;
        }
        catch (Exception e) {
            log.error("SimpleDataSource: Error while loading properties. Cause: " + e.toString(), e);
            throw new RuntimeException("SimpleDataSource: Error while loading properties. Cause: " + e, e);
        }
        this.idle = new IdleThread(this.hashCode());
        this.idle.start();
    }

    void initialize(Map<Object, Object> props) throws Exception {
        if (!(props.containsKey(PROP_JDBC_DRIVER) && props.containsKey(PROP_JDBC_URL) && props.containsKey(PROP_JDBC_USERNAME) && props.containsKey(PROP_JDBC_PASSWORD))) {
            throw new RuntimeException("SimpleDataSource: Some properties were not set.");
        }
        this.jdbcDriver = (String)props.get(PROP_JDBC_DRIVER);
        this.jdbcUrl = (String)props.get(PROP_JDBC_URL);
        this.jdbcUsername = (String)props.get(PROP_JDBC_USERNAME);
        this.jdbcPassword = (String)props.get(PROP_JDBC_PASSWORD);
        this.poolMaxActive = SimpleDataSource.propInt(props, PROP_POOL_MAX_ACTIVE_CONN, 10);
        this.poolMaxIdle = SimpleDataSource.propInt(props, PROP_POOL_MAX_IDLE_CONN, 5);
        this.poolMaxCheckoutTime = SimpleDataSource.propInt(props, PROP_POOL_MAX_CHECKOUT_TIME, 20000);
        this.poolTimeToWait = SimpleDataSource.propInt(props, PROP_POOL_TIME_TO_WAIT, 20000);
        if (this.poolTimeToWait < 1000) {
            this.poolTimeToWait = 1000;
        }
        this.poolPingEnabled = SimpleDataSource.propBool(props, PROP_POOL_PING_ENABLED, false);
        this.poolPingQuery = SimpleDataSource.propStr(props, PROP_POOL_PING_QUERY, null);
        this.poolPingConnOlderThan = SimpleDataSource.propInt(props, PROP_POOL_PING_CONN_OLDER_THAN, 0);
        this.poolPingConnNotUsedFor = SimpleDataSource.propInt(props, PROP_POOL_PING_CONN_NOT_USED_FOR, 0);
        this.poolPingIdleConnAfter = SimpleDataSource.propInt(props, PROP_POOL_PING_IDLE_CONN_AFTER, 0);
        this.poolEraseIdleConnAfter = SimpleDataSource.propInt(props, PROP_POOL_Erase_IDLE_CONN_AFTER, 0);
        this.poolShutdownDelay = SimpleDataSource.propInt(props, PROP_POOL_ShutdownDelay, 10000);
        this.poolLogSqlOverdueThan = SimpleDataSource.propInt(props, PROP_POOL_LogSqlOverdueThan, 0);
        this.sql_executor_threshold = SimpleDataSource.propInt(props, "sql_executor_threshold", 1000);
        this.jdbcDefaultAutoCommit = SimpleDataSource.propBool(props, PROP_JDBC_DEFAULT_AUTOCOMMIT, null);
        this.defaultTransactionIsolation = SimpleDataSource.toTransactionIsolation(props.get(PROP_JDBC_DEFAULT_TRANSACTIONISOLATION));
        this.poolCommitOnReturn = SimpleDataSource.propBool(props, PROP_POOL_CommitOnReturn, false);
        this.useDriverProps = false;
        this.driverProps = new Properties();
        this.driverProps.put("user", this.jdbcUsername);
        this.driverProps.put("password", this.jdbcPassword);
        for (Object key : props.keySet()) {
            String name = String.valueOf(key);
            String value = String.valueOf(props.get(key));
            if (!name.startsWith(ADD_DRIVER_PROPS_PREFIX)) continue;
            this.driverProps.put(name.substring(ADD_DRIVER_PROPS_PREFIX_LENGTH), value);
            this.useDriverProps = true;
        }
        Properties driverPropsCopy = new Properties();
        driverPropsCopy.putAll((Map<?, ?>)this.driverProps);
        if (driverPropsCopy.containsKey("password")) {
            driverPropsCopy.setProperty("password", "******");
        }
        this.driverProperties = this.useDriverProps ? driverPropsCopy.toString() : "{}";
        Resources.instantiate(this.jdbcDriver);
        RunStats.getInstance().addStat(this);
    }

    static String propStr(Map<Object, Object> props, String key, String defVal) {
        Object i = props.get(key);
        if (i != null) {
            return String.valueOf(i);
        }
        return defVal;
    }

    static Boolean propBool(Map<Object, Object> props, String key, Boolean defVal) {
        Object i = props.get(key);
        if (i instanceof Boolean) {
            return (Boolean)i;
        }
        if (i != null) {
            return Boolean.parseBoolean(String.valueOf(i));
        }
        return defVal;
    }

    static int propInt(Map<Object, Object> props, String key, int defVal) {
        Object i = props.get(key);
        if (i instanceof Number) {
            return ((Number)i).intValue();
        }
        if (i != null) {
            return Integer.parseInt(String.valueOf(i));
        }
        return defVal;
    }

    static String toTransactionIsolationName(Integer ti) {
        if (ti == null) {
            return "Default";
        }
        if (ti == 0) {
            return "NONE";
        }
        if (ti == 1) {
            return "READ_UNCOMMITTED";
        }
        if (ti == 2) {
            return "READ_COMMITTED";
        }
        if (ti == 4) {
            return "REPEATABLE_READ";
        }
        if (ti == 8) {
            return "SERIALIZABLE";
        }
        return "UNKNOWN: " + ti;
    }

    static Integer toTransactionIsolation(Object oti) {
        if (oti == null) {
            return null;
        }
        if (oti instanceof Integer) {
            return (Integer)oti;
        }
        String ti = String.valueOf(oti).toUpperCase();
        if (ti.contains("NONE")) {
            return 0;
        }
        if (ti.contains("READ") && ti.contains("UNCOMMITTED")) {
            return 1;
        }
        if (ti.contains("READ") && ti.contains("COMMITTED")) {
            return 2;
        }
        if (ti.contains("REPEATABLE") && ti.contains("READ")) {
            return 4;
        }
        if (ti.endsWith("SERIALIZABLE")) {
            return 8;
        }
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.popConnection().open();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (!this.jdbcUsername.equals(username)) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.popConnection().open();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        DriverManager.setLoginTimeout(loginTimeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        DriverManager.setLogWriter(logWriter);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public int getPoolPingConnectionsNotUsedFor() {
        return this.poolPingConnNotUsedFor;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public int getPoolMaximumActiveConnections() {
        return this.poolMaxActive;
    }

    public int getPoolMaximumIdleConnections() {
        return this.poolMaxIdle;
    }

    public int getPoolMaximumCheckoutTime() {
        return this.poolMaxCheckoutTime;
    }

    public int getPoolTimeToWait() {
        return this.poolTimeToWait;
    }

    public String getPoolPingQuery() {
        return this.poolPingQuery;
    }

    public boolean isPoolPingEnabled() {
        return this.poolPingEnabled;
    }

    public int getPoolPingConnectionsOlderThan() {
        return this.poolPingConnOlderThan;
    }

    public long getRequestCount() {
        return this.stat.requestCount;
    }

    public long getAvgRequestTime() {
        return this.stat.requestCount == 0L ? 0L : this.stat.totalRequestTime / this.stat.requestCount;
    }

    public long getAvgWaitTime() {
        return this.stat.hadToWaitCount == 0L ? 0L : this.stat.totalWaitTime / this.stat.hadToWaitCount;
    }

    public long getHadToWaitCount() {
        return this.stat.hadToWaitCount;
    }

    public long getBadConnectionCount() {
        return this.stat.badConnectionCount;
    }

    public long getClaimedOverdueCount() {
        return this.stat.claimedOverdueCount;
    }

    public long getAvgOverdueUseTime() {
        return this.stat.claimedOverdueCount == 0L ? 0L : this.stat.totalOverdueCheckoutTime / this.stat.claimedOverdueCount;
    }

    public long getAvgCheckoutTime() {
        return this.stat.requestCount == 0L ? 0L : this.stat.totalCheckoutTime / this.stat.requestCount;
    }

    @Override
    public String getStatus(String h) {
        StringBuilder buf = new StringBuilder("PoolStatus " + this.hashCode() + " :");
        h = h == null ? "\n" : "\n" + h;
        String rc = String.valueOf(this.stat.requestCount);
        int w = rc.length();
        buf.append(h).append(" ---------------------------------------------------------------------------------");
        buf.append(h).append(" jdbcDriver         ").append(this.jdbcDriver);
        buf.append(h).append(" jdbcUrl            ").append(this.jdbcUrl);
        buf.append(h).append(" jdbcUsername       ").append(SimpleDataSource.pad(this.jdbcUsername)).append(" jdbcPassword             ").append(this.jdbcPassword == null ? "NULL" : "******");
        buf.append(h).append(" requestCount       ").append(SimpleDataSource.pad(rc)).append(" defaultAutoCommit        ").append(this.jdbcDefaultAutoCommit);
        buf.append(h).append("  idleConnections   ").append(SimpleDataSource.pad(w, this.idleConnections.size())).append(" transactionIsolation     ").append(SimpleDataSource.toTransactionIsolationName(this.defaultTransactionIsolation));
        buf.append(h).append("  activeConnections ").append(SimpleDataSource.pad(w, this.activeConnections.size())).append(" driverProperties         ").append(this.driverProperties);
        buf.append(h).append("  reuseCount        ").append(SimpleDataSource.pad(w, this.stat.reuseCount)).append(" poolMaxActiveConnections ").append(this.poolMaxActive);
        buf.append(h).append("  closeCount        ").append(SimpleDataSource.pad(w, this.stat.closeCount)).append(" poolMaxIdleConnections   ").append(this.poolMaxIdle);
        buf.append(h).append("  eraseCount        ").append(SimpleDataSource.pad(w, this.stat.eraseCount)).append(" poolMaxCheckoutTime      ").append(this.poolMaxCheckoutTime);
        buf.append(h).append("  claimedOverdue    ").append(SimpleDataSource.pad(w, this.stat.claimedOverdueCount)).append(" poolTimeToWait           ").append(this.poolTimeToWait);
        buf.append(h).append("  badCount          ").append(SimpleDataSource.pad(w, this.stat.badConnectionCount)).append(" poolPingIdleConnsAfter   ").append(this.poolPingIdleConnAfter);
        buf.append(h).append(" avgRequestTime     ").append(SimpleDataSource.pad(this.getAvgRequestTime())).append(" poolEraseIdleConnsAfter  ").append(this.poolEraseIdleConnAfter);
        buf.append(h).append(" avgCheckoutTime    ").append(SimpleDataSource.pad(this.getAvgCheckoutTime())).append(" poolPingConnsOlderThan   ").append(this.poolPingConnOlderThan);
        buf.append(h).append(" avgOverdueUseTime  ").append(SimpleDataSource.pad(this.getAvgOverdueUseTime())).append(" poolPingConnsNotUsedFor  ").append(this.poolPingConnNotUsedFor);
        buf.append(h).append(" waitCount          ").append(SimpleDataSource.pad(this.stat.hadToWaitCount)).append(" poolPingEnabled          ").append(this.poolPingEnabled);
        buf.append(h).append(" avgWaitTime        ").append(SimpleDataSource.pad(this.getAvgWaitTime())).append(" poolPingQuery            ").append(this.poolPingQuery);
        buf.append(h).append(" maxIdleCount       ").append(SimpleDataSource.pad(this.maxIdleCount)).append(" poolShutdownDelay        ").append(this.poolShutdownDelay);
        buf.append(h).append(" maxActiveCount     ").append(SimpleDataSource.pad(this.maxActiveCount)).append(" poolCommitOnReturn       ").append(this.poolCommitOnReturn);
        buf.append(h).append(" sql_exec_threshold ").append(SimpleDataSource.pad(this.sql_executor_threshold)).append(" poolLogSqlOverdueThan    ").append(this.poolLogSqlOverdueThan);
        buf.append(h).append(" ---------------------------------------------------------------------------------");
        return buf.toString();
    }

    static String pad(Object o) {
        String s = String.valueOf(o);
        if (s.length() <= 16) {
            return s + SP16.substring(0, 16 - s.length());
        }
        return s;
    }

    static String pad(int w, Number o) {
        String s = String.valueOf(o);
        if (s.length() <= w && w <= 16) {
            return SP16.substring(0, w - s.length()) + s + SP16.substring(w);
        }
        if (s.length() <= 16) {
            return s + SP16.substring(0, 16 - s.length());
        }
        return s;
    }

    public void forceCloseAll() {
        try {
            Thread.sleep(this.poolShutdownDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IdleThread t = this.idle;
        if (t == null) {
            return;
        }
        this.idle = null;
        this.activeConnections.forEach(new With<SimplePooledConnection>(){

            @Override
            public boolean with(SimplePooledConnection conn) {
                try {
                    conn.invalidate();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        });
        this.idleConnections.forEach(new With<SimplePooledConnection>(){

            @Override
            public boolean with(SimplePooledConnection conn) {
                try {
                    conn.invalidate();
                    SimpleDataSource.this.cleanConn(conn);
                    SimpleDataSource.this.closeConn(conn);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++((SimpleDataSource)SimpleDataSource.this).stat.closeCount;
                return true;
            }
        });
        log.warn("SimpleDataSource " + this.hashCode() + " forcefully shutdown.");
        try {
            log.info(this.getStatus("iBATIS ! "));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            t.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.notifyPool();
    }

    void closeConn(SimplePooledConnection conn) {
        try {
            if (conn.getRealConnection() != null) {
                conn.getRealConnection().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean cleanConn(SimplePooledConnection conn) {
        try {
            Connection c = conn.getRealConnection();
            if (c != null) {
                if (!c.getAutoCommit()) {
                    if (this.poolCommitOnReturn) {
                        c.commit();
                    } else {
                        c.rollback();
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error("Clean connection " + conn.getRealHashCode() + " error: " + e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushConnection(SimplePooledConnection conn) throws SQLException {
        int closeCount = 0;
        int totalCheckoutTime = 0;
        int badConnectionCount = 0;
        int eraseCount = 0;
        try {
            boolean real = this.activeConnections.remove(conn, false);
            if (!real) {
                if (log.isDebugEnabled()) {
                    log.debug("Overdue connection " + conn.getRealHashCode() + " returned to pool.");
                }
            } else if (!conn.isValid()) {
                this.cleanConn(conn);
                this.closeConn(conn);
                ++closeCount;
                if (log.isDebugEnabled()) {
                    log.debug("Closed connection " + conn.getRealHashCode());
                }
            } else {
                int ret = this.pingFree(conn, false);
                if (ret == 0) {
                    if (this.idleConnections.size() < this.poolMaxIdle) {
                        totalCheckoutTime = (int)((long)totalCheckoutTime + conn.getCheckoutTime());
                        if (this.cleanConn(conn)) {
                            SimplePooledConnection newConn = new SimplePooledConnection(conn.getRealConnection(), this);
                            newConn.setCreatedTimestamp(conn.getCreatedTimestamp());
                            newConn.setLastUsedTimestamp(conn.getLastUsedTimestamp());
                            long size = this.idleConnections.put(newConn);
                            if (size > this.maxIdleCount) {
                                this.maxIdleCount = size;
                            }
                            conn.invalidate();
                            this.notifyPool();
                        } else {
                            this.closeConn(conn);
                            ++badConnectionCount;
                            if (log.isDebugEnabled()) {
                                log.debug("Bad connection " + conn.getRealHashCode() + " returned");
                            }
                        }
                    } else {
                        totalCheckoutTime = (int)((long)totalCheckoutTime + conn.getCheckoutTime());
                        this.cleanConn(conn);
                        this.closeConn(conn);
                        ++closeCount;
                        if (log.isDebugEnabled()) {
                            log.debug("Closed connection " + conn.getRealHashCode());
                        }
                    }
                } else if (ret < 0) {
                    ++badConnectionCount;
                    log.debug("Bad connection " + conn.getRealHashCode() + " returned");
                    this.closeConn(conn);
                } else {
                    ++eraseCount;
                    log.debug("Erase bad connection " + conn.getRealHashCode() + " returned");
                }
            }
        }
        finally {
            this.stat.closeCount += (long)closeCount;
            this.stat.totalCheckoutTime += (long)totalCheckoutTime;
            this.stat.badConnectionCount += (long)badConnectionCount;
            this.stat.eraseCount += (long)eraseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitPool(long timeToWait) {
        this.poolLock.lock();
        try {
            this.forIdle.await(timeToWait, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.poolLock.unlock();
        }
    }

    void notifyPool() {
        this.poolLock.lock();
        try {
            this.forIdle.signalAll();
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimplePooledConnection popConnection() throws SQLException {
        if (this.idle == null) {
            throw new SQLException("SimpleDataSource " + this.hashCode() + ": pool closed.");
        }
        boolean countedWait = false;
        SimplePooledConnection conn = null;
        long t = System.currentTimeMillis();
        int localBadConnectionCount = 0;
        while (conn == null) {
            long reuseCount = 0L;
            long badConnectionCount = 0L;
            long eraseCount = 0L;
            long totalOverdueCheckoutTime = 0L;
            long totalCheckoutTime = 0L;
            long claimedOverdueCount = 0L;
            long hadToWaitCount = 0L;
            long totalWaitTime = 0L;
            long requestCount = 0L;
            long totalRequestTime = 0L;
            try {
                conn = this.idleConnections.take();
                if (conn != null) {
                    int ret = this.pingFree(conn, true);
                    if (ret == 0) {
                        ++reuseCount;
                    } else {
                        if (ret < 0) {
                            log.debug("Bad connection " + conn.getRealHashCode() + " returned from the idle pool.");
                            ++badConnectionCount;
                            ++localBadConnectionCount;
                        } else {
                            log.debug("Erase old connection " + conn.getRealHashCode());
                            ++eraseCount;
                        }
                        conn = null;
                    }
                } else {
                    if (this.activeConnections.size() < this.poolMaxActive) {
                        conn = this.useDriverProps ? new SimplePooledConnection(DriverManager.getConnection(this.jdbcUrl, this.driverProps), this) : new SimplePooledConnection(DriverManager.getConnection(this.jdbcUrl, this.jdbcUsername, this.jdbcPassword), this);
                        if (this.defaultTransactionIsolation != null) {
                            conn.getRealConnection().setTransactionIsolation(this.defaultTransactionIsolation);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Created connection " + conn.getRealHashCode());
                        }
                    } else if (this.poolMaxCheckoutTime > 0) {
                        long longestCheckoutTime;
                        SimplePooledConnection oldest = this.activeConnections.peek();
                        long l = longestCheckoutTime = oldest != null ? oldest.getCheckoutTime() : 0L;
                        if (longestCheckoutTime > (long)this.poolMaxCheckoutTime) {
                            if (!this.activeConnections.remove(oldest, true)) continue;
                            totalOverdueCheckoutTime += longestCheckoutTime;
                            totalCheckoutTime += longestCheckoutTime;
                            conn = new SimplePooledConnection(oldest.getRealConnection(), this);
                            conn.setCreatedTimestamp(oldest.getCreatedTimestamp());
                            conn.setLastUsedTimestamp(oldest.getLastUsedTimestamp());
                            oldest.invalidate();
                            int ret = this.pingFree(conn, true);
                            if (ret == 0 && this.cleanConn(conn)) {
                                ++claimedOverdueCount;
                                if (log.isDebugEnabled()) {
                                    log.debug("Claimed overdue connection " + conn.getRealHashCode());
                                }
                            } else {
                                if (ret > 0) {
                                    log.debug("Erase old claimed connection " + oldest.getRealHashCode());
                                    ++eraseCount;
                                } else {
                                    this.closeConn(conn);
                                    log.debug("Bad connection " + conn.getRealHashCode() + " claimed from the active pool.");
                                    ++badConnectionCount;
                                    ++localBadConnectionCount;
                                }
                                conn = null;
                            }
                        }
                    }
                    if (conn == null) {
                        try {
                            if (!countedWait) {
                                ++hadToWaitCount;
                                countedWait = true;
                            }
                            long wt = System.currentTimeMillis();
                            this.waitPool(this.poolTimeToWait);
                            totalWaitTime += System.currentTimeMillis() - wt;
                        }
                        catch (Exception wt) {
                            // empty catch block
                        }
                    }
                }
                if (conn != null) {
                    conn.setCheckoutTimestamp(System.currentTimeMillis());
                    conn.setLastUsedTimestamp(System.currentTimeMillis());
                    if (this.jdbcDefaultAutoCommit != null && this.jdbcDefaultAutoCommit.booleanValue() != conn.getRealConnection().getAutoCommit()) {
                        conn.getRealConnection().setAutoCommit(this.jdbcDefaultAutoCommit);
                    }
                    ++requestCount;
                    long size = this.activeConnections.put(conn);
                    if (size > this.maxActiveCount) {
                        this.maxActiveCount = size;
                    }
                    t = System.currentTimeMillis() - t;
                    totalRequestTime += t;
                    if (t <= (long)this.poolTimeToWait) continue;
                    log.warn("Wait as long as " + t + " milliseconds for connection " + conn.getRealHashCode());
                    this.dumpThread();
                    continue;
                }
                if (localBadConnectionCount <= this.poolMaxIdle + 3) continue;
                if (log.isDebugEnabled()) {
                    log.debug("SimpleDataSource: Could not get a good connection to the database.");
                }
                throw new SQLException("SimpleDataSource: Could not get a good connection to the database.");
            }
            finally {
                this.stat.reuseCount += reuseCount;
                this.stat.badConnectionCount += badConnectionCount;
                this.stat.eraseCount += eraseCount;
                this.stat.totalOverdueCheckoutTime += totalOverdueCheckoutTime;
                this.stat.totalCheckoutTime += totalCheckoutTime;
                this.stat.claimedOverdueCount += claimedOverdueCount;
                this.stat.hadToWaitCount += hadToWaitCount;
                this.stat.totalWaitTime += totalWaitTime;
                this.stat.requestCount += requestCount;
                this.stat.totalRequestTime += totalRequestTime;
            }
        }
        return conn;
    }

    void dumpThread() {
        if (this.threadDumped.compareAndSet(false, true)) {
            log.warn("iBATIS Thread dump start ...");
            Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
            for (Thread t : all.keySet()) {
                StackTraceElement[] stes;
                log.info(t.toString());
                for (StackTraceElement ste : stes = all.get(t)) {
                    log.warn("\t" + ste);
                }
            }
            log.info("iBATIS Thread dump Okey!");
        }
    }

    int pingFree(SimplePooledConnection conn, boolean out) {
        try {
            if (conn.getRealConnection().isClosed()) {
                return -1;
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Connection " + conn.getRealHashCode() + " is BAD: " + e.getMessage());
            }
            return -1;
        }
        if (this.poolEraseIdleConnAfter > 0 && conn.getAge() > (long)this.poolEraseIdleConnAfter) {
            this.closeConn(conn);
            return 1;
        }
        if (this.poolPingEnabled && (this.poolPingConnOlderThan > 0 && conn.getAge() > (long)this.poolPingConnOlderThan || this.poolPingConnNotUsedFor > 0 && conn.getTimeElapsedSinceLastUse() > (long)this.poolPingConnNotUsedFor)) {
            try {
                boolean ok = this.pingConn(conn.getRealConnection());
                if (ok) {
                    return 0;
                }
                if (out) {
                    log.debug("Pool connection " + conn.getRealHashCode() + " is BAD by ping.");
                } else {
                    log.debug("User connection " + conn.getRealHashCode() + " is BAD by ping.");
                }
                return -1;
            }
            catch (Exception e) {
                this.closeConn(conn);
                return -1;
            }
        }
        return 0;
    }

    public static Connection unwrapConnection(Connection conn) {
        if (conn instanceof SimplePooledConnection) {
            return ((SimplePooledConnection)conn).getRealConnection();
        }
        return conn;
    }

    protected void finalize() throws Throwable {
        this.forceCloseAll();
    }

    boolean pingConn(Connection realConn) {
        String sql = this.getRealPingQuery(realConn);
        if (sql == null || sql.isEmpty()) {
            return true;
        }
        long time = System.currentTimeMillis();
        PreparedStatement statement = null;
        try {
            statement = realConn.prepareStatement(sql);
        }
        catch (Exception t) {
            this.realPingQuery = "";
            log.warn("Preparation of ping query '" + sql + "' failed: " + t.getMessage());
            return true;
        }
        try {
            ResultSet rs = statement.executeQuery();
            rs.close();
            statement.close();
            if (!realConn.getAutoCommit()) {
                realConn.rollback();
            }
            if ((time = System.currentTimeMillis() - time) > 10000L) {
                if (log.isDebugEnabled()) {
                    log.debug("Connection " + realConn.hashCode() + " maybe BAD, ping elapse " + time + " ms");
                }
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            log.warn("Execution of ping query '" + sql + "' failed: " + t.getMessage());
            return false;
        }
    }

    String getRealPingQuery(Connection conn) {
        if (this.realPingQuery == null) {
            if (this.poolPingQuery == null || this.poolPingQuery.trim().isEmpty()) {
                String prod = null;
                try {
                    prod = conn.getMetaData().getDatabaseProductName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                prod = String.valueOf(prod).toLowerCase();
                if (prod.indexOf("oracle") >= 0) {
                    this.realPingQuery = "select 1 from dual";
                } else if (prod.indexOf("db2") >= 0) {
                    this.realPingQuery = "select 1 from sysibm.SYSDUMMY1";
                } else if (prod.indexOf("mysql") >= 0) {
                    this.realPingQuery = "select current_date";
                } else if (prod.indexOf("microsoft") >= 0) {
                    this.realPingQuery = "select getdate()";
                } else if (prod.indexOf("derby") >= 0) {
                    this.realPingQuery = "select 1 from sysibm.SYSDUMMY1";
                } else {
                    log.warn("Unknown Database: " + prod + ", Please set parameter: " + PROP_POOL_PING_QUERY);
                    this.realPingQuery = "";
                }
            } else {
                this.realPingQuery = this.poolPingQuery;
            }
        }
        return this.realPingQuery;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static class Que<E> {
        volatile int size = 0;
        volatile Node<E> first;
        volatile Node<E> last;

        Que() {
        }

        public int size() {
            return this.size;
        }

        public synchronized void forEach(With<E> cb) {
            Node<E> x = this.last;
            while (x != null) {
                Node<E> n = x;
                x = x.prev;
                if (!cb.with(n.item)) continue;
                this.unlink(n);
            }
        }

        public synchronized long put(E e) {
            if (e == null) {
                throw new NullPointerException();
            }
            Node<E> l = this.last;
            Node<E> newNode = new Node<E>(l, e, null);
            this.last = newNode;
            if (l == null) {
                this.first = newNode;
            } else {
                l.next = newNode;
            }
            ++this.size;
            return this.size;
        }

        public synchronized boolean remove(E e, boolean isFirst) {
            if (isFirst) {
                if (this.first != null && e == this.first.item) {
                    this.unlink(this.first);
                    return true;
                }
                return false;
            }
            Node<E> x = this.first;
            while (x != null) {
                if (e == x.item || x.item.equals(e)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
            return false;
        }

        private void unlink(Node<E> x) {
            Node next = x.next;
            Node prev = x.prev;
            if (prev == null) {
                this.first = next;
            } else {
                prev.next = next;
                x.prev = null;
            }
            if (next == null) {
                this.last = prev;
            } else {
                next.prev = prev;
                x.next = null;
            }
            x.item = null;
            --this.size;
        }

        public synchronized E take() {
            Node<E> f = this.first;
            if (f == null) {
                return null;
            }
            Object element = f.item;
            Node next = f.next;
            f.item = null;
            f.next = null;
            this.first = next;
            if (next == null) {
                this.last = null;
            } else {
                next.prev = null;
            }
            --this.size;
            return element;
        }

        public E peek() {
            Node<E> f = this.first;
            if (f == null) {
                return null;
            }
            return f.item;
        }
    }

    static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }

    static interface With<E> {
        public boolean with(E var1);
    }

    class IdleThread
    extends Thread {
        IdleThread(int id) {
            this.setName("iBATIS Idle " + id);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final int[] eraseCount = new int[1];
            block11: while (SimpleDataSource.this.idle != null && SimpleDataSource.this.poolMaxIdle > 0 && (SimpleDataSource.this.poolPingIdleConnAfter > 0 || SimpleDataSource.this.poolEraseIdleConnAfter > 0)) {
                int badConnectionCount = 0;
                try {
                    SimplePooledConnection spc;
                    Thread.sleep(30000L);
                    if (SimpleDataSource.this.idleConnections.size() <= 0) continue;
                    if (SimpleDataSource.this.poolEraseIdleConnAfter > 0) {
                        SimpleDataSource.this.idleConnections.forEach(new With<SimplePooledConnection>(){

                            @Override
                            public boolean with(SimplePooledConnection spc) {
                                if (spc.getAge() > (long)SimpleDataSource.this.poolEraseIdleConnAfter) {
                                    try {
                                        SimpleDataSource.this.closeConn(spc);
                                        log.debug("Erase old idle connection " + spc.getRealHashCode());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    eraseCount[0] = eraseCount[0] + 1;
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    while (SimpleDataSource.this.poolPingIdleConnAfter > 0 && (spc = (SimplePooledConnection)SimpleDataSource.this.idleConnections.take()) != null) {
                        if (spc.getTimeElapsedSinceLastUse() < (long)SimpleDataSource.this.poolPingIdleConnAfter) {
                            SimpleDataSource.this.idleConnections.put(spc);
                            SimpleDataSource.this.notifyPool();
                            continue block11;
                        }
                        if (this.pingIdle(spc)) {
                            spc.setLastUsedTimestamp(System.currentTimeMillis());
                            if (SimpleDataSource.this.idleConnections.size() < SimpleDataSource.this.poolMaxIdle) {
                                SimpleDataSource.this.idleConnections.put(spc);
                                SimpleDataSource.this.notifyPool();
                                continue;
                            }
                            try {
                                SimpleDataSource.this.closeConn(spc);
                                log.debug("Erase extra idle connection " + spc.getRealHashCode());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            eraseCount[0] = eraseCount[0] + 1;
                            continue;
                        }
                        try {
                            SimpleDataSource.this.closeConn(spc);
                            log.debug("Erase bad idle connection " + spc.getRealHashCode());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++badConnectionCount;
                    }
                }
                catch (Throwable t) {
                    if (SimpleDataSource.this.idle == null) break;
                    log.error(this.getName() + " error: " + t.getMessage(), t);
                }
                finally {
                    ((SimpleDataSource)SimpleDataSource.this).stat.eraseCount += (long)eraseCount[0];
                    ((SimpleDataSource)SimpleDataSource.this).stat.badConnectionCount += (long)badConnectionCount;
                    eraseCount[0] = 0;
                }
            }
        }

        boolean pingIdle(SimplePooledConnection conn) {
            try {
                if (conn.getRealConnection().isClosed()) {
                    return false;
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Idle Connection " + conn.getRealHashCode() + " is BAD: " + e.getMessage());
                }
                return false;
            }
            boolean ok = SimpleDataSource.this.pingConn(conn);
            if (!ok && log.isDebugEnabled()) {
                log.debug("Idle connection " + conn.getRealHashCode() + " is BAD by ping.");
            }
            return ok;
        }
    }

    static class Stat {
        volatile long requestCount = 0L;
        volatile long reuseCount = 0L;
        volatile long closeCount = 0L;
        volatile long eraseCount = 0L;
        volatile long claimedOverdueCount = 0L;
        volatile long badConnectionCount = 0L;
        volatile long totalRequestTime = 0L;
        volatile long totalCheckoutTime = 0L;
        volatile long totalOverdueCheckoutTime = 0L;
        volatile long totalWaitTime = 0L;
        volatile long hadToWaitCount = 0L;

        Stat() {
        }
    }
}

