/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.jdbc.SimpleCallableStatement;
import com.ibatis.common.jdbc.SimpleDataSource;
import com.ibatis.common.jdbc.SimplePreparedStatement;
import com.ibatis.common.jdbc.SimpleStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

class SimplePooledConnection
implements Connection {
    private SimpleDataSource dataSource;
    private Connection realConnection;
    private long checkoutTimestamp;
    private long createdTimestamp;
    private long lastUsedTimestamp;
    int logOverdue;
    int logThreshold;
    private boolean valid;
    private boolean closed;

    SimplePooledConnection(Connection connection, SimpleDataSource dataSource) {
        this.realConnection = connection;
        this.dataSource = dataSource;
        this.createdTimestamp = System.currentTimeMillis();
        this.lastUsedTimestamp = System.currentTimeMillis();
        this.valid = true;
        this.logOverdue = dataSource.poolLogSqlOverdueThan;
        this.logThreshold = dataSource.sql_executor_threshold;
    }

    private boolean needWrap() {
        return this.logOverdue > 0;
    }

    void invalidate() {
        this.valid = false;
    }

    boolean isValid() {
        return this.valid;
    }

    Connection getRealConnection() {
        return this.realConnection;
    }

    public Connection open() {
        this.closed = false;
        return this;
    }

    int getRealHashCode() {
        if (this.realConnection == null) {
            return 0;
        }
        return this.realConnection.hashCode();
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long lastUsedTimestamp) {
        this.lastUsedTimestamp = lastUsedTimestamp;
    }

    public long getTimeElapsedSinceLastUse() {
        return System.currentTimeMillis() - this.lastUsedTimestamp;
    }

    long getAge() {
        return System.currentTimeMillis() - this.createdTimestamp;
    }

    public long getCheckoutTimestamp() {
        return this.checkoutTimestamp;
    }

    public void setCheckoutTimestamp(long timestamp) {
        this.checkoutTimestamp = timestamp;
    }

    public long getCheckoutTime() {
        return System.currentTimeMillis() - this.checkoutTimestamp;
    }

    private Connection getValidConnection() throws SQLException {
        if (!this.valid) {
            throw new SQLException("Connection " + this.getRealHashCode() + " is invalid.");
        }
        return this.realConnection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.needWrap()) {
            return new SimpleStatement(this, this.getValidConnection().createStatement(), null);
        }
        return this.getValidConnection().createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql), sql);
        }
        return this.getValidConnection().prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.needWrap()) {
            return new SimpleCallableStatement(this, this.getValidConnection().prepareCall(sql), sql);
        }
        return this.getValidConnection().prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getValidConnection().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Connection conn = this.getValidConnection();
        if (conn.getAutoCommit() != autoCommit) {
            conn.setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getValidConnection().getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.getValidConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getValidConnection().rollback();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.dataSource.pushConnection(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.valid || this.closed || this.getValidConnection().isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getValidConnection().getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getValidConnection().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getValidConnection().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getValidConnection().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getValidConnection().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getValidConnection().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getValidConnection().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getValidConnection().clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.needWrap()) {
            return new SimpleStatement(this, this.getValidConnection().createStatement(resultSetType, resultSetConcurrency), null);
        }
        return this.getValidConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }
        return this.getValidConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.needWrap()) {
            return new SimpleCallableStatement(this, this.getValidConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        }
        return this.getValidConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getValidConnection().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getValidConnection().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getValidConnection().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getValidConnection().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getValidConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getValidConnection().setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getValidConnection().rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getValidConnection().releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.needWrap()) {
            return new SimpleStatement(this, this.getValidConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), null);
        }
        return this.getValidConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        return this.getValidConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.needWrap()) {
            return new SimpleCallableStatement(this, this.getValidConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        return this.getValidConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql, autoGeneratedKeys), sql);
        }
        return this.getValidConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql, columnIndexes), sql);
        }
        return this.getValidConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.needWrap()) {
            return new SimplePreparedStatement(this, this.getValidConnection().prepareStatement(sql, columnNames), sql);
        }
        return this.getValidConnection().prepareStatement(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getValidConnection().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getValidConnection().isWrapperFor(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getValidConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getValidConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getValidConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getValidConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.valid && this.realConnection != null && this.getValidConnection().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getValidConnection().setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getValidConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getValidConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getValidConnection().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getValidConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getValidConnection().createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.getValidConnection().setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getValidConnection().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getValidConnection().abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.getValidConnection().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getValidConnection().getNetworkTimeout();
    }

    public String toString() {
        return "iBATIS Connection " + this.getRealHashCode();
    }
}

