/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.Objects;
import com.ibatis.common.jdbc.SimplePooledConnection;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleStatement
implements Statement {
    static final ILog log = ILogFactory.getLog("org.ibatis.Debuger");
    Statement stat;
    SimplePooledConnection conn;
    protected String sql;
    Map<Object, Object> args = new LinkedHashMap<Object, Object>();

    public SimpleStatement(SimplePooledConnection conn, Statement stat, String sql) {
        this.conn = conn;
        this.stat = stat;
        this.sql = sql;
    }

    protected void cleanArgs() {
        this.args.clear();
    }

    protected void addArg(Object idx, Object x) {
        this.args.put(idx, x);
    }

    protected void clean() {
        this.sql = null;
        this.args.clear();
    }

    protected void debugSql(String call, long startTime, String sql, Object result) {
        long t = System.currentTimeMillis() - startTime;
        if (t >= (long)this.conn.logThreshold) {
            call = call + " -> " + result;
            if (this.args.isEmpty()) {
                log.warn(call + " - " + t + "\n  +-- " + sql);
            } else {
                log.warn(call + " - " + t + "\n  +-- " + sql + "\n  +-- " + SimpleStatement.toStr(this.args));
            }
        } else if (t + 1L >= (long)this.conn.logOverdue) {
            call = call + " -> " + result;
            if (this.args.isEmpty()) {
                log.info(call + " - " + t + "\n  +-- " + sql);
            } else {
                log.info(call + " - " + t + "\n  +-- " + sql + "\n  +-- " + SimpleStatement.toStr(this.args));
            }
        }
    }

    static String toStr(Map<Object, Object> args) {
        StringBuilder buf = new StringBuilder("{ ");
        for (Map.Entry<Object, Object> arg : args.entrySet()) {
            String s;
            Object obj;
            if (buf.length() > 2) {
                buf.append(", ");
            }
            if (arg.getKey() instanceof Integer) {
                obj = arg.getValue();
                if (obj instanceof Date) {
                    Objects.outputDate(buf, (Date)obj);
                    continue;
                }
                if (obj instanceof String) {
                    buf.append("'").append(obj).append("'");
                    continue;
                }
                if (obj instanceof byte[]) {
                    s = "0x**";
                    try {
                        s = new String((byte[])obj, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    buf.append("'").append(s).append("'");
                    continue;
                }
                buf.append(obj);
                continue;
            }
            buf.append(String.valueOf(arg.getKey())).append(" : ");
            obj = arg.getValue();
            if (obj instanceof Date) {
                Objects.outputDate(buf, (Date)obj);
                continue;
            }
            if (obj instanceof String) {
                buf.append("'").append(obj).append("'");
                continue;
            }
            if (obj instanceof byte[]) {
                s = "0x**";
                try {
                    s = new String((byte[])obj, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                buf.append("'").append(s).append("'");
                continue;
            }
            buf.append(obj);
        }
        buf.append(" }");
        return buf.toString();
    }

    protected Statement stat() {
        return this.stat;
    }

    protected PreparedStatement pstat() {
        return (PreparedStatement)this.stat;
    }

    protected CallableStatement cstat() {
        return (CallableStatement)this.stat;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stat().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stat().isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        ResultSet rset = this.stat().executeQuery(sql);
        this.debugSql("executeQuery(String)", t, sql, "[ResultSet]");
        return rset;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        int ret = this.stat().executeUpdate(sql);
        this.debugSql("executeUpdate(String)", t, sql, ret);
        return ret;
    }

    @Override
    public void close() throws SQLException {
        this.clean();
        this.stat().close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stat().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stat().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stat().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stat().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stat().setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stat().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stat().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.stat().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stat().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stat().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stat().setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        boolean ret = this.stat().execute(sql);
        this.debugSql("execute(String)", t, sql, ret);
        return ret;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.stat().getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stat().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stat().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stat().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stat().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stat().setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stat().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stat().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stat().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.sql = sql;
        this.stat().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.sql = null;
        this.stat().clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long t = System.currentTimeMillis();
        int[] ret = this.stat().executeBatch();
        int total = 0;
        int fail = 0;
        if (ret != null) {
            for (int r : ret) {
                if (r > 0) {
                    total += r;
                    continue;
                }
                ++fail;
            }
        }
        if (fail == 0) {
            this.debugSql("executeBatch()", t, this.sql, total);
        } else {
            this.debugSql("executeBatch()", t, this.sql, total + " | " + fail);
        }
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stat().getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stat().getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        int ret = this.stat().executeUpdate(sql, autoGeneratedKeys);
        this.debugSql("executeUpdate(String, int)", t, sql, ret);
        return ret;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        int ret = this.stat().executeUpdate(sql, columnIndexes);
        this.debugSql("executeUpdate(String, int[])", t, sql, ret);
        return ret;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        int ret = this.stat().executeUpdate(sql, columnNames);
        this.debugSql("executeUpdate(String, String[])", t, sql, ret);
        return ret;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        boolean ret = this.stat().execute(sql, autoGeneratedKeys);
        this.debugSql("execute(String, int)", t, sql, ret);
        return ret;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        boolean ret = this.stat().execute(sql, columnIndexes);
        this.debugSql("execute(String, int[])", t, sql, ret);
        return ret;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        long t = System.currentTimeMillis();
        this.clean();
        boolean ret = this.stat().execute(sql, columnNames);
        this.debugSql("execute(String, String[])", t, sql, ret);
        return ret;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stat().getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stat().isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stat().setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stat().isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stat().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stat().isCloseOnCompletion();
    }
}

