/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.logging;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.resources.Resources;
import java.lang.reflect.Constructor;

public class ILogFactory {
    private static Constructor<?> logConstructor;

    private static void tryImplementation(String testClassName, String implClassName) {
        if (logConstructor == null) {
            try {
                Resources.classForName(testClassName);
                Class<?> implClass = Resources.classForName(implClassName);
                logConstructor = implClass.getConstructor(String.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static ILog getLog(Class<?> aClass) {
        try {
            return (ILog)logConstructor.newInstance(aClass.getName());
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger for class " + aClass + ".  Cause: " + t, t);
        }
    }

    public static ILog getLog(String name) {
        try {
            return (ILog)logConstructor.newInstance(name);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger for name " + name + ".  Cause: " + t, t);
        }
    }

    public static synchronized void selectLog4JLogging() {
        try {
            Resources.classForName("org.apache.log4j.Logger");
            Class<?> implClass = Resources.classForName("com.ibatis.common.logging.log4j.Log4jImpl");
            logConstructor = implClass.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void selectJavaLogging() {
        try {
            Resources.classForName("java.util.logging.Logger");
            Class<?> implClass = Resources.classForName("com.ibatis.common.logging.jdk14.Jdk14LoggingImpl");
            logConstructor = implClass.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        ILogFactory.tryImplementation("org.apache.commons.logging.LogFactory", "com.ibatis.common.logging.jakarta.JakartaCommonsLoggingImpl");
        ILogFactory.tryImplementation("java.util.logging.Logger", "com.ibatis.common.logging.jdk14.Jdk14LoggingImpl");
        ILogFactory.tryImplementation("java.lang.Object", "com.ibatis.common.logging.nologging.NoLoggingImpl");
    }
}

