/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.xml;

import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeletParser {
    private Map<String, Nodelet> letMap = new HashMap<String, Nodelet>();
    private boolean validation;
    private EntityResolver entityResolver;

    public void addNodelet(String xpath, Nodelet nodelet) {
        this.letMap.put(xpath, nodelet);
    }

    public void parse(String resource, Reader reader) throws NodeletException {
        try {
            Document doc = this.createDocument(reader);
            this.parse(doc.getLastChild());
        }
        catch (SAXParseException e) {
            throw new NodeletException("Error parsing [" + resource + ", " + e.getLineNumber() + "].  Cause: " + e, e);
        }
        catch (NodeletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NodeletException("Error parsing [" + resource + "].  Cause: " + e, e);
        }
    }

    public void parse(String resource, InputStream inputStream) throws NodeletException {
        try {
            Document doc = this.createDocument(inputStream);
            this.parse(doc.getLastChild());
        }
        catch (SAXParseException e) {
            throw new NodeletException("Error parsing [" + resource + ", " + e.getLineNumber() + "].  Cause: " + e);
        }
        catch (NodeletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NodeletException("Error parsing [" + resource + "].  Cause: " + e, e);
        }
    }

    public void parse(Node node) {
        Path path = new Path();
        this.processNodelet(node, "/");
        this.process(node, path);
    }

    private void process(Node node, Path path) {
        if (node instanceof Element) {
            String elementName = node.getNodeName();
            path.add(elementName);
            this.processNodelet(node, path.toString());
            this.processNodelet(node, "//" + elementName);
            NamedNodeMap attributes = node.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node att = attributes.item(i);
                String attrName = att.getNodeName();
                path.add("@" + attrName);
                this.processNodelet(att, path.toString());
                this.processNodelet(node, "//@" + attrName);
                path.remove();
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.process(children.item(i), path);
            }
            path.add("end()");
            this.processNodelet(node, path.toString());
            path.remove();
            path.remove();
        } else if (node instanceof Text) {
            path.add("text()");
            this.processNodelet(node, path.toString());
            this.processNodelet(node, "//text()");
            path.remove();
        }
    }

    private void processNodelet(Node node, String pathString) {
        Nodelet nodelet = this.letMap.get(pathString);
        if (nodelet != null) {
            try {
                nodelet.process(node);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing XPath '" + pathString + "'.  Cause: " + e, e);
            }
        }
    }

    private Document createDocument(Reader reader) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.validation);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this.entityResolver);
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        });
        return builder.parse(new InputSource(reader));
    }

    private Document createDocument(InputStream inputStream) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.validation);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this.entityResolver);
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        });
        return builder.parse(new InputSource(inputStream));
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    private static class Path {
        private List<String> nodeList = new ArrayList<String>();

        public void add(String node) {
            this.nodeList.add(node);
        }

        public void remove() {
            this.nodeList.remove(this.nodeList.size() - 1);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("/");
            for (int i = 0; i < this.nodeList.size(); ++i) {
                buffer.append(this.nodeList.get(i));
                if (i >= this.nodeList.size() - 1) continue;
                buffer.append("/");
            }
            return buffer.toString();
        }
    }
}

