/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.xml;

import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeletUtils {
    public static boolean getBooleanAttribute(Properties attribs, String name, boolean def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return "true".equals(value);
    }

    public static int getIntAttribute(Properties attribs, String name, int def) {
        String value = attribs.getProperty(name);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public static Properties parseAttributes(Node n) {
        return NodeletUtils.parseAttributes(n, null);
    }

    public static Properties parseAttributes(Node n, Properties variables) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node attribute = attributeNodes.item(i);
            String value = NodeletUtils.parsePropertyTokens(attribute.getNodeValue(), variables);
            attributes.put(attribute.getNodeName(), value);
        }
        return attributes;
    }

    public static String parsePropertyTokens(String string, Properties variables) {
        String OPEN = "${";
        int CLOSE = 125;
        String newString = string;
        if (newString != null && variables != null) {
            int start = newString.indexOf("${");
            int end = newString.indexOf(125);
            while (start >= 0 && end > start) {
                String propValue;
                String prepend = newString.substring(0, start);
                String append = newString.substring(end + 1);
                String propName = newString.substring(start + 2, end);
                int commaIndex = propName.indexOf(58);
                String defaultValue = propName;
                if (commaIndex >= 0) {
                    defaultValue = propName.substring(commaIndex + 1);
                    propName = propName.substring(0, commaIndex);
                }
                newString = (propValue = variables.getProperty(propName)) == null ? prepend + defaultValue + append : prepend + propValue + append;
                start = newString.indexOf("${");
                end = newString.indexOf(125);
            }
        }
        return newString;
    }
}

