/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.client;

import com.ibatis.sqlmap.engine.scope.ErrorContext;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;

public class BatchResult
implements Serializable {
    private static final long serialVersionUID = 5329502080151453045L;
    private String sql;
    private String statementId;
    private ErrorContext errorContext;
    private int[] updateCounts;
    private transient PreparedStatement preparedStatement;
    public int total;
    public int totalRows;
    private ArrayList<Object[]> args;
    private Object[] lastArg;

    public BatchResult(int batchSize, String sql, ErrorContext ec) {
        this.statementId = ec.getObjectId();
        this.sql = sql;
        this.errorContext = ec;
        if (ec.getSql() == null) {
            this.errorContext.setSql(sql);
        }
        this.args = batchSize > 0 ? new ArrayList(batchSize) : new ArrayList();
    }

    public String getSql() {
        return this.sql;
    }

    public int[] getUpdateCounts() {
        return this.updateCounts;
    }

    public void setUpdateCounts(int[] updateCounts) {
        this.updateCounts = updateCounts;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setPreparedStatement(PreparedStatement pstat) {
        this.preparedStatement = pstat;
        if (pstat == null) {
            this.args.clear();
        }
    }

    public void addArgs(Object[] os) {
        this.args.add(os);
        this.lastArg = os;
    }

    public Object[] getArgs(int i) {
        if (i < 0 || i >= this.args.size()) {
            return this.lastArg;
        }
        return this.args.get(i);
    }

    public ErrorContext getErrorContext() {
        return this.errorContext;
    }
}

