/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.client;

import com.ibatis.sqlmap.client.lexer.SqlLexer;
import com.ibatis.sqlmap.client.lexer.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class LogR {
    static Map<String, int[]> qmap = new HashMap<String, int[]>();
    static Map<String, int[]> fmap = new HashMap<String, int[]>();
    static Map<String, int[]> omap = new HashMap<String, int[]>();

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("java -jar jbatis-2.4.x.jar <text-file> <gz-file> ...");
            return;
        }
        for (String arg : args) {
            File f = new File(arg);
            if (!f.isFile()) {
                System.err.println("Bad log file: " + args[0]);
                continue;
            }
            LogR.statsLog(f);
        }
        LogR.showStats();
    }

    static void statsLog(File f) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(f);
        InputStreamReader r = null;
        r = f.getName().endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(is)) : new InputStreamReader(is);
        BufferedReader br = new BufferedReader(r);
        String line = br.readLine();
        while (line != null) {
            int idx = line.indexOf("-- Current_sql - ");
            if (idx >= 0) {
                String sql = line.substring(idx + 17);
                SqlLexer sl = new SqlLexer(sql);
                Token head = sl.firstKeyword();
                if (head != null) {
                    switch (head.type) {
                        case Select: {
                            LogR.addQuery(sl.getRoots());
                            break;
                        }
                        case Insert: 
                        case Replace: 
                        case Update: 
                        case Delete: {
                            LogR.addFlush(sl.getRoots());
                            break;
                        }
                        default: {
                            System.out.println("Unkown sql: " + sql);
                        }
                    }
                }
            } else {
                int of;
                idx = line.indexOf("-- Current_obj - ");
                if (idx >= 0 && (of = line.indexOf(" of ", idx + 17)) > 0) {
                    LogR.addSqlId(line.substring(idx + 17, of));
                }
            }
            line = br.readLine();
        }
        br.close();
    }

    static void showStats() {
        System.out.println("---------- object stats ------------");
        Map.Entry[] me = omap.entrySet().toArray(new Map.Entry[omap.size()]);
        Arrays.sort(me, new MeIComparator());
        for (Map.Entry e : me) {
            System.out.println(((int[])e.getValue())[0] + "\t" + (String)e.getKey());
        }
        System.out.println("---------- query stats ------------");
        me = qmap.entrySet().toArray(new Map.Entry[qmap.size()]);
        Arrays.sort(me, new MeIComparator());
        for (Map.Entry e : me) {
            System.out.println(((int[])e.getValue())[0] + "\t" + (String)e.getKey());
        }
        System.out.println("---------- flush stats ------------");
        me = fmap.entrySet().toArray(new Map.Entry[fmap.size()]);
        Arrays.sort(me, new MeIComparator());
        for (Map.Entry e : me) {
            System.out.println(((int[])e.getValue())[0] + "\t" + (String)e.getKey());
        }
    }

    static void addFlush(List<String> roots) {
        if (roots != null) {
            for (String t : roots) {
                int[] c = fmap.get(t = t.replace("`", "").toLowerCase());
                if (c == null) {
                    fmap.put(t, new int[]{1});
                    continue;
                }
                c[0] = c[0] + 1;
            }
        }
    }

    static void addQuery(List<String> roots) {
        if (roots != null) {
            for (String t : roots) {
                int[] c = qmap.get(t = t.replace("`", "").toLowerCase());
                if (c == null) {
                    qmap.put(t, new int[]{1});
                    continue;
                }
                c[0] = c[0] + 1;
            }
        }
    }

    static void addSqlId(String id) {
        int[] c = omap.get(id);
        if (c == null) {
            omap.put(id, new int[]{1});
        } else {
            c[0] = c[0] + 1;
        }
    }

    static class MeIComparator
    implements Comparator<Map.Entry<String, int[]>> {
        MeIComparator() {
        }

        @Override
        public int compare(Map.Entry<String, int[]> o1, Map.Entry<String, int[]> o2) {
            return o2.getValue()[0] - o1.getValue()[0];
        }
    }
}

