/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.client.lexer;

import com.ibatis.sqlmap.client.lexer.TT;
import com.ibatis.sqlmap.client.lexer.Token;
import com.ibatis.sqlmap.client.lexer.Tokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SqlLexer {
    private final String sql;
    private final TT[] keywords;
    private List<Token> tokens;
    private List<Token> cascade;

    public SqlLexer(String sql) {
        this(sql, TT.words);
    }

    public SqlLexer(String sql, TT[] words) {
        this.sql = sql != null ? sql : "sql_is_null";
        this.keywords = words;
    }

    public int indexOf(TT tt) {
        return Tokens.indexOf(this.getTokens(), tt);
    }

    public int indexOf(TT tt, int fromIndex) {
        return Tokens.indexOf(this.getTokens(), tt, fromIndex);
    }

    public int lastIndexOf(TT tt) {
        return Tokens.lastIndexOf(this.getTokens(), tt);
    }

    public int lastIndexOf(TT tt, int fromIndex) {
        return Tokens.lastIndexOf(this.getTokens(), tt, fromIndex);
    }

    public int topIndexOf(TT tt) {
        return Tokens.indexOf(this.getCascadeTokens(), tt);
    }

    public int topIndexOf(TT tt, int fromIndex) {
        return Tokens.indexOf(this.getCascadeTokens(), tt, fromIndex);
    }

    public int topLastIndexOf(TT tt) {
        return Tokens.lastIndexOf(this.getCascadeTokens(), tt);
    }

    public int topLastIndexOf(TT tt, int fromIndex) {
        return Tokens.lastIndexOf(this.getCascadeTokens(), tt, fromIndex);
    }

    public SqlLexer trim() {
        TT tt;
        int end;
        int start;
        List<Token> tokens = this.getTokens();
        for (start = 0; tokens.get((int)start).type == TT.Space && start < tokens.size(); ++start) {
        }
        for (end = tokens.size() - 1; end > start && ((tt = tokens.get((int)end).type) == TT.Space || tt == TT.SemiColon); --end) {
        }
        if (start > 0 || end < tokens.size() - 1) {
            this.tokens = tokens.subList(start, end + 1);
        }
        return this;
    }

    public List<Token> getTokens() {
        if (this.tokens == null) {
            this.parse();
        }
        return this.tokens;
    }

    public Token firstKeyword() {
        return Tokens.firstKeyword(this.getTokens());
    }

    public String getSql() {
        return this.sql;
    }

    SqlLexer parse() {
        int offset = 0;
        ArrayList<Token> list = new ArrayList<Token>();
        boolean inQuote = false;
        TT tt = null;
        StringBuilder buf = new StringBuilder(64);
        for (char c : this.sql.toCharArray()) {
            if (inQuote) {
                buf.append(c);
                if (c == '\'') {
                    inQuote = false;
                }
            } else {
                switch (c) {
                    case '\'': {
                        this.closeToken(tt, list, buf, offset);
                        inQuote = true;
                        tt = TT.Literal;
                        buf.append(c);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (tt == TT.Space) break;
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Space;
                        buf.append(' ');
                        break;
                    }
                    case '*': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Asterisk;
                        buf.append(c);
                        break;
                    }
                    case '.': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Dot;
                        buf.append(c);
                        break;
                    }
                    case '(': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Lp;
                        buf.append(c);
                        break;
                    }
                    case ')': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Rp;
                        buf.append(c);
                        break;
                    }
                    case ',': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Comma;
                        buf.append(c);
                        break;
                    }
                    case ';': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.SemiColon;
                        buf.append(c);
                        break;
                    }
                    case '?': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Question;
                        buf.append(c);
                        break;
                    }
                    case '!': 
                    case '%': 
                    case '&': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '^': 
                    case '|': 
                    case '~': {
                        this.closeToken(tt, list, buf, offset);
                        tt = TT.Operator;
                        buf.append(c);
                        break;
                    }
                    default: {
                        if (tt != TT.Word) {
                            this.closeToken(tt, list, buf, offset);
                        }
                        tt = TT.Word;
                        buf.append(c);
                    }
                }
            }
            ++offset;
        }
        this.closeToken(tt, list, buf, offset);
        tt = null;
        this.tokens = list;
        return this;
    }

    void closeToken(TT tt, List<Token> list, StringBuilder buf, int offset) {
        if (tt != null && buf.length() > 0) {
            String word = buf.toString();
            if (tt == TT.Word) {
                tt = this.toKeyword(tt, word);
            }
            list.add(new Token(tt, offset - word.length(), word));
        }
        buf.setLength(0);
    }

    TT toKeyword(TT tt, String word) {
        int lw = word.length();
        String w = null;
        for (TT kw : this.keywords) {
            int lk = kw.text.length();
            if (lw != lk) continue;
            if (w == null) {
                w = word.toUpperCase(Locale.ROOT);
            }
            if (!w.equals(kw.text)) continue;
            return kw;
        }
        return tt;
    }

    SqlLexer cascade() {
        List<Token> tokens = this.getTokens();
        ArrayList<Token> cascade = new ArrayList<Token>();
        int level = 0;
        Tokens curr = null;
        for (Token t : tokens) {
            if (t.type == TT.Lp) {
                if (level == 0) {
                    cascade.add(t);
                    curr = new Tokens(t.offset + 1);
                } else {
                    curr.addToken(t);
                }
                ++level;
                continue;
            }
            if (t.type == TT.Rp) {
                if (--level > 0 && curr != null) {
                    curr.addToken(t);
                    continue;
                }
                if (curr != null) {
                    curr.trim();
                    if (curr.size() > 0) {
                        cascade.add(curr);
                    }
                    curr = null;
                }
                cascade.add(t);
                continue;
            }
            if (level == 0) {
                cascade.add(t);
                continue;
            }
            curr.addToken(t);
        }
        this.cascade = cascade;
        return this;
    }

    public List<Token> getCascadeTokens() {
        if (this.cascade == null) {
            this.cascade();
        }
        return this.cascade;
    }

    public List<String> getRoots() {
        List<Token> tokens = this.getTokens();
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        Token head = this.firstKeyword();
        if (head == null) {
            return Collections.emptyList();
        }
        TT tt = head.type;
        ArrayList<String> list = new ArrayList<String>(5);
        if (tt == TT.Select) {
            Tokens.calcRoots(list, this.getCascadeTokens());
        } else if (tt == TT.Insert || tt == TT.Replace) {
            int lpIdx;
            int intoIdx = this.indexOf(TT.Into, 1);
            if (intoIdx > 0 && (lpIdx = this.indexOf(TT.Lp, intoIdx + 1)) > 0) {
                Tokens.addRoot(list, tokens, intoIdx + 1, lpIdx);
            }
        } else if (tt == TT.Update) {
            int setIdx = this.indexOf(TT.Set, 1);
            if (setIdx > 0) {
                Tokens.addRoot(list, tokens, 1, setIdx);
            }
        } else if (tt == TT.Delete) {
            int fromIdx = this.indexOf(TT.From, 1);
            if (fromIdx > 0) {
                int whereIdx = this.indexOf(TT.Where, fromIdx + 1);
                if (whereIdx > 0) {
                    Tokens.addRoot(list, tokens, fromIdx + 1, whereIdx);
                } else {
                    Tokens.addRoot(list, tokens, fromIdx + 1, tokens.size());
                }
            }
        } else {
            list.add(this.getSql());
        }
        return list;
    }
}

