/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.client.lexer;

import com.ibatis.sqlmap.client.lexer.TT;
import com.ibatis.sqlmap.client.lexer.Token;
import java.util.ArrayList;
import java.util.List;

public class Tokens
extends Token {
    private List<Token> tokens = new ArrayList<Token>();
    private List<Token> cascade;

    public Tokens(int offset) {
        super(TT.Clause, offset);
    }

    public void addToken(Token t) {
        this.tokens.add(t);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    int size() {
        return this.tokens.size();
    }

    public Tokens trim() {
        int end;
        int start;
        List<Token> tokens = this.getTokens();
        for (start = 0; tokens.get((int)start).type == TT.Space && start < tokens.size(); ++start) {
        }
        for (end = tokens.size() - 1; tokens.get((int)end).type == TT.Space && end > start; --end) {
        }
        if (start > 0 || end < tokens.size() - 1) {
            this.tokens = tokens.subList(start, end + 1);
        }
        return this;
    }

    Tokens cascade() {
        ArrayList<Token> cascade = new ArrayList<Token>();
        int level = 0;
        Tokens curr = null;
        for (Token t : this.getTokens()) {
            if (t.type == TT.Lp) {
                if (level == 0) {
                    cascade.add(t);
                    curr = new Tokens(t.offset + 1);
                } else {
                    curr.addToken(t);
                }
                ++level;
                continue;
            }
            if (t.type == TT.Rp) {
                if (--level > 0 && curr != null) {
                    curr.addToken(t);
                    continue;
                }
                if (curr != null) {
                    curr.trim();
                    if (curr.size() > 0) {
                        cascade.add(curr);
                    }
                    curr = null;
                }
                cascade.add(t);
                continue;
            }
            if (level == 0) {
                cascade.add(t);
                continue;
            }
            curr.addToken(t);
        }
        this.cascade = cascade;
        return this;
    }

    public List<Token> getCascadeTokens() {
        if (this.cascade == null) {
            this.cascade();
        }
        return this.cascade;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + " " + this.cascade;
    }

    static void calcRoots(List<String> list, List<Token> ts) {
        int fromIdx = Tokens.indexOf(ts, TT.From);
        if (fromIdx > 0) {
            int start;
            int idx;
            for (int i = 1; i < fromIdx; ++i) {
                List<Token> sub;
                Token head;
                Token t = ts.get(i);
                if (t.type != TT.Clause || (head = Tokens.firstKeyword(sub = ((Tokens)t).getCascadeTokens())) == null || head.type != TT.Select) continue;
                Tokens.calcRoots(list, sub);
            }
            int rootEndIdx = Tokens.indexOf(ts, TT.Group, fromIdx + 1);
            if (rootEndIdx < 0) {
                rootEndIdx = Tokens.indexOf(ts, TT.Where, fromIdx + 1);
            }
            if (rootEndIdx < 0) {
                rootEndIdx = Tokens.indexOf(ts, TT.Order, fromIdx + 1);
            }
            if (rootEndIdx < 0) {
                rootEndIdx = Tokens.indexOf(ts, TT.Limit, fromIdx + 1);
            }
            if (rootEndIdx < 0) {
                rootEndIdx = ts.size();
            }
            for (idx = start = fromIdx + 1; idx < rootEndIdx; ++idx) {
                Token t = ts.get(idx);
                if (t.type != TT.Comma && t.type != TT.Join) continue;
                Tokens.calcRoots(list, ts, start, idx);
                start = idx + 1;
            }
            Tokens.calcRoots(list, ts, start, idx);
            for (int i = rootEndIdx + 1; i < ts.size(); ++i) {
                List<Token> sub;
                Token head;
                Token t = ts.get(i);
                if (t.type != TT.Clause || (head = Tokens.firstKeyword(sub = ((Tokens)t).getCascadeTokens())) == null || head.type != TT.Select) continue;
                Tokens.calcRoots(list, sub);
            }
        }
    }

    public static Token firstKeyword(List<Token> tokens) {
        for (Token t : tokens) {
            if (!t.type.word || t.type.text == null) continue;
            return t;
        }
        return null;
    }

    static void calcRoots(List<String> list, List<Token> ts, int start, int end) {
        int idx = Tokens.indexOf(ts, TT.Clause, start);
        if (idx > 0 && idx < end) {
            Token t = ts.get(idx);
            Tokens.calcRoots(list, ((Tokens)t).getCascadeTokens());
            return;
        }
        idx = Tokens.indexOf(ts, TT.On, start);
        if (idx > start && idx < end) {
            end = idx;
        }
        Tokens.addRoot(list, ts, start, end);
    }

    static void addRoot(List<String> list, List<Token> ts, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            Token t = ts.get(i);
            if (t.type == TT.Word) {
                if (buf.length() != 0 && buf.charAt(buf.length() - 1) != '.') break;
                buf.append(t.text);
                continue;
            }
            if (t.type != TT.Dot) continue;
            if (buf.length() <= 0 || buf.charAt(buf.length() - 1) == '.') break;
            buf.append('.');
        }
        if (buf.length() > 0) {
            String root = buf.toString();
            list.add(root);
        }
    }

    public static int indexOf(List<Token> tokens, TT tt) {
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get((int)i).type != tt) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<Token> tokens, TT tt, int fromIndex) {
        int idx = 0;
        if (idx < fromIndex) {
            idx = fromIndex;
        }
        for (int i = idx; i < tokens.size(); ++i) {
            if (tokens.get((int)i).type != tt) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(List<Token> tokens, TT tt) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            if (tokens.get((int)i).type != tt) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(List<Token> tokens, TT tt, int fromIndex) {
        int idx = tokens.size() - 1;
        if (idx > fromIndex) {
            idx = fromIndex;
        }
        for (int i = idx; i >= 0; --i) {
            if (tokens.get((int)i).type != tt) continue;
            return i;
        }
        return -1;
    }
}

