/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.accessplan;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.engine.accessplan.AccessPlan;
import com.ibatis.sqlmap.engine.accessplan.BaseAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.ComplexAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.EnhancedPropertyAccessPlanX;
import com.ibatis.sqlmap.engine.accessplan.MapAccessPlan;
import com.ibatis.sqlmap.engine.accessplan.PropertyAccessPlan;
import java.util.Map;

public class AccessPlanFactory {
    static final ILog log = ILogFactory.getLog(AccessPlanFactory.class.getPackage().getName());
    private static boolean bytecodeEnhancementEnabled = true;

    private AccessPlanFactory() {
    }

    public static AccessPlan getAccessPlan(Class<?> clazz, String[] propertyNames) {
        BaseAccessPlan plan;
        boolean complex = false;
        if (clazz == null || propertyNames == null) {
            complex = true;
        } else {
            for (int i = 0; i < propertyNames.length; ++i) {
                String pn = propertyNames[i];
                if (pn.indexOf(91) < 0 && pn.indexOf(46) < 0) continue;
                complex = true;
                break;
            }
        }
        if (complex) {
            plan = new ComplexAccessPlan(clazz, propertyNames);
        } else if (Map.class.isAssignableFrom(clazz)) {
            plan = new MapAccessPlan(clazz, propertyNames);
        } else if (bytecodeEnhancementEnabled) {
            try {
                plan = new EnhancedPropertyAccessPlanX(clazz, propertyNames);
            }
            catch (Throwable t) {
                log.warn("EnhancedAccessPlan failed -> " + t.getMessage());
                try {
                    plan = new PropertyAccessPlan(clazz, propertyNames);
                }
                catch (Throwable t2) {
                    plan = new ComplexAccessPlan(clazz, propertyNames);
                }
            }
        } else {
            try {
                plan = new PropertyAccessPlan(clazz, propertyNames);
            }
            catch (Throwable t) {
                plan = new ComplexAccessPlan(clazz, propertyNames);
            }
        }
        return plan;
    }

    public static boolean isBytecodeEnhancementEnabled() {
        return bytecodeEnhancementEnabled;
    }

    public static void setBytecodeEnhancementEnabled(boolean bytecodeEnhancementEnabled) {
        AccessPlanFactory.bytecodeEnhancementEnabled = bytecodeEnhancementEnabled;
    }
}

