/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.accessplan;

import com.ibatis.common.beans.ProbeException;
import com.ibatis.sqlmap.engine.accessplan.BaseAccessPlan;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ibatis.cglib.BulkBeanX;
import org.ibatis.cglib.GetFieldInvoker;
import org.ibatis.cglib.Invoker;
import org.ibatis.cglib.MethodInvoker;
import org.ibatis.cglib.ReflectUtil;
import org.ibatis.cglib.SetFieldInvoker;

public class EnhancedPropertyAccessPlanX
extends BaseAccessPlan {
    private BulkBeanX bulkBean;
    private static final Map<Object, BulkBeanX> beans = new LinkedHashMap<Object, BulkBeanX>(){
        private static final long serialVersionUID = 8323514817332962624L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, BulkBeanX> eldest) {
            return this.size() > ReflectUtil.getCatchSize();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedPropertyAccessPlanX(Class<?> clazz, String[] propertyNames) throws Exception {
        super(clazz, propertyNames);
        Map<Object, BulkBeanX> map = beans;
        synchronized (map) {
            this.bulkBean = beans.get(this);
            if (this.bulkBean == null) {
                this.bulkBean = this.createBulkBean(clazz, Integer.toHexString(this.hashCode()), propertyNames);
                beans.put(this, this.bulkBean);
            }
        }
    }

    public int hashCode() {
        int hashCode = this.clazz.hashCode();
        if (this.propertyNames != null) {
            for (String s : this.propertyNames) {
                hashCode = 31 * hashCode + (s == null ? 0 : s.hashCode());
            }
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnhancedPropertyAccessPlanX) {
            EnhancedPropertyAccessPlanX epx = (EnhancedPropertyAccessPlanX)o;
            if (this.clazz != epx.clazz) {
                return false;
            }
            if (this.propertyNames == epx.propertyNames) {
                return true;
            }
            if (this.propertyNames == null || epx.propertyNames == null) {
                return false;
            }
            if (this.propertyNames.length != epx.propertyNames.length) {
                return false;
            }
            for (int i = this.propertyNames.length - 1; i > 0; --i) {
                String o1 = this.propertyNames[i];
                String o2 = epx.propertyNames[i];
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    BulkBeanX createBulkBean(Class<?> clazz, Object key, String[] propertyNames) throws Exception {
        Method[] getterNames = new Method[propertyNames.length];
        Method[] setterNames = new Method[propertyNames.length];
        Field[] names = new Field[propertyNames.length];
        Invoker[] getters = this.getGetters(propertyNames);
        Invoker[] setters = this.getSetters(propertyNames);
        for (int i = 0; i < propertyNames.length; ++i) {
            if (getters[i] == null) {
                throw new ProbeException("No READABLE property '" + propertyNames[i] + "' in class '" + clazz.getName() + "'");
            }
            if (setters[i] == null) {
                throw new ProbeException("No WRITEABLE property '" + propertyNames[i] + "' found in class '" + clazz.getName() + "'");
            }
            if (getters[i] instanceof MethodInvoker) {
                getterNames[i] = ((MethodInvoker)getters[i]).getMethod();
            } else if (getters[i] instanceof GetFieldInvoker) {
                names[i] = ((GetFieldInvoker)getters[i]).getField();
            }
            if (setters[i] instanceof MethodInvoker) {
                setterNames[i] = ((MethodInvoker)setters[i]).getMethod();
                continue;
            }
            if (!(setters[i] instanceof SetFieldInvoker)) continue;
            names[i] = ((SetFieldInvoker)setters[i]).getField();
        }
        return BulkBeanX.create(clazz, key, propertyNames, getterNames, setterNames, names);
    }

    @Override
    public void setProperties(Object object, Object[] values) {
        this.bulkBean.setPropertyValues(object, values);
    }

    @Override
    public Object[] getProperties(Object object) {
        return this.bulkBean.getPropertyValues(object);
    }
}

