/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.StringTokenizer;
import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.XMLSqlSource;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.MappedStatementConfig;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.util.HashMap;
import java.util.Properties;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlStatementParser {
    private XmlParserState state;
    private boolean strict;
    private HashMap<String, String> statemetCache = new HashMap();

    public SqlStatementParser(XmlParserState config, boolean strict) {
        this.state = config;
        this.strict = strict;
    }

    public void resetStatemetCache() {
        this.statemetCache.clear();
    }

    public void parseGeneralStatement(Node node, MappedStatement statement, boolean canBatch, String batchReverseAttr) {
        Properties attributes = NodeletUtils.parseAttributes(node, this.state.getGlobalProps());
        String id = attributes.getProperty("id");
        if (this.strict && id.indexOf(35) >= 0) {
            throw new SqlMapException("Illegal statement id: " + id);
        }
        if (this.statemetCache.put(id, "") != null) {
            throw new SqlMapException("There is already a statement: " + id);
        }
        String parameterMapName = this.state.applyNamespace(attributes.getProperty("parameterMap"));
        String parameterClassName = attributes.getProperty("parameterClass");
        String resultMapName = attributes.getProperty("resultMap");
        String resultClassName = attributes.getProperty("resultClass");
        String cacheModelName = this.state.applyNamespace(attributes.getProperty("cacheModel"));
        String resultSetType = attributes.getProperty("resultSetType");
        String fetchSize = attributes.getProperty("fetchSize");
        String allowRemapping = attributes.getProperty("remapResults");
        String timeout = attributes.getProperty("timeout");
        if (this.state.isUseStatementNamespaces()) {
            id = this.state.applyNamespace(id);
        }
        String[] additionalResultMapNames = null;
        if (resultMapName != null) {
            StringTokenizer st = new StringTokenizer(resultMapName, ',', true);
            int tc = st.countTokens();
            resultMapName = tc > 0 ? this.state.applyNamespace(st.nextToken()) : null;
            if (tc > 1) {
                additionalResultMapNames = new String[tc - 1];
                for (int i = 0; i < additionalResultMapNames.length; ++i) {
                    additionalResultMapNames[i] = this.state.applyNamespace(st.nextToken());
                }
            }
        }
        String[] additionalResultClassNames = null;
        if (resultClassName != null) {
            StringTokenizer st = new StringTokenizer(resultClassName, ',', true);
            int tc = st.countTokens();
            resultClassName = tc > 0 ? st.nextToken() : null;
            if (tc > 1) {
                additionalResultClassNames = new String[tc - 1];
                for (int i = 0; i < additionalResultClassNames.length; ++i) {
                    additionalResultClassNames[i] = st.nextToken();
                }
            }
        }
        this.state.getConfig().getErrorContext().setMoreInfo("Check the parameter class.");
        Class<?> parameterClass = this.resolveClass(parameterClassName);
        this.state.getConfig().getErrorContext().setMoreInfo("Check the result class.");
        Class<?> resultClass = this.resolveClass(resultClassName);
        Class[] additionalResultClasses = null;
        if (additionalResultClassNames != null) {
            additionalResultClasses = new Class[additionalResultClassNames.length];
            for (int i = 0; i < additionalResultClassNames.length; ++i) {
                additionalResultClasses[i] = this.resolveClass(additionalResultClassNames[i]);
            }
        }
        Integer timeoutInt = timeout == null ? null : new Integer(timeout);
        Integer fetchSizeInt = fetchSize == null ? null : new Integer(fetchSize);
        boolean allowRemappingBool = "true".equals(allowRemapping);
        if (batchReverseAttr != null && "true".equals(attributes.getProperty(batchReverseAttr))) {
            canBatch = !canBatch;
        }
        MappedStatementConfig statementConf = this.state.getConfig().newMappedStatementConfig(id, statement, new XMLSqlSource(this.state, node), parameterMapName, parameterClass, resultMapName, additionalResultMapNames, resultClass, additionalResultClasses, resultSetType, fetchSizeInt, allowRemappingBool, timeoutInt, cacheModelName, canBatch);
        if (this.state.getConfig().getDelegate().getSqlExecutor().isCheckSql()) {
            statement.checkSql(this.state.getConfig().getErrorContext());
        }
        this.findAndParseSelectKey(node, statementConf);
        this.findAndParseFlushCache(node, statementConf);
        this.findAndParseFlushCacheRoot(node, statementConf);
    }

    private Class<?> resolveClass(String resultClassName) {
        try {
            if (resultClassName != null) {
                return Resources.classForName(this.state.getConfig().getTypeHandlerFactory().resolveAlias(resultClassName));
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not initialize class.  Cause: " + e, e);
        }
    }

    private void findAndParseSelectKey(Node node, MappedStatementConfig config) {
        this.state.getConfig().getErrorContext().setActivity("parsing select key tags");
        boolean foundSQLFirst = false;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                String data = ((CharacterData)child).getData();
                if (!SqlText.isNotEmpty(data = SqlText.cleanSql(data, i == 0))) continue;
                foundSQLFirst = true;
                continue;
            }
            if (child.getNodeType() != 1 || !"selectKey".equals(child.getNodeName())) continue;
            Properties attributes = NodeletUtils.parseAttributes(child, this.state.getGlobalProps());
            String keyPropName = attributes.getProperty("keyProperty");
            String resultClassName = attributes.getProperty("resultClass");
            boolean genKey = !child.hasChildNodes();
            String type = attributes.getProperty("type");
            if (genKey) {
                foundSQLFirst = true;
            } else if (type != null) {
                foundSQLFirst = !"pre".equals(type);
            }
            config.setSelectKeyStatement(new XMLSqlSource(this.state, child), resultClassName, keyPropName, foundSQLFirst, genKey);
            break;
        }
        this.state.getConfig().getErrorContext().setMoreInfo(null);
    }

    private void findAndParseFlushCacheRoot(Node node, MappedStatementConfig config) {
        this.state.getConfig().getErrorContext().setActivity("parsing flushCacheRoot tags");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Properties attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"flushCacheRoot".equals(child.getNodeName()) || (name = (attributes = NodeletUtils.parseAttributes(child, this.state.getGlobalProps())).getProperty("name")) == null || name.isEmpty()) continue;
            config.addFlushCacheRoot(name.toLowerCase().trim());
        }
        this.state.getConfig().getErrorContext().setMoreInfo(null);
    }

    private void findAndParseFlushCache(Node node, MappedStatementConfig config) {
        this.state.getConfig().getErrorContext().setActivity("parsing flushCache tags");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"flushCache".equals(child.getNodeName())) continue;
            Properties attributes = NodeletUtils.parseAttributes(child, this.state.getGlobalProps());
            String entityClass = attributes.getProperty("entityClass");
            if (entityClass != null && !entityClass.isEmpty()) {
                entityClass = this.state.getConfig().getTypeHandlerFactory().resolveAlias(entityClass);
                Class<?> clazz = null;
                try {
                    this.state.getConfig().getErrorContext().setMoreInfo("Check the entity class.");
                    clazz = Resources.classForName(entityClass);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error configuring flushCache.  Could not set ResultClass.  Cause: " + e, e);
                }
                config.addFlushEntityCache(clazz);
                continue;
            }
            String cacheModel = attributes.getProperty("cacheModel");
            if (cacheModel == null || cacheModel.isEmpty()) {
                throw new RuntimeException("Error configuring flushOnFlush.  cacheModel is emtpy.");
            }
            config.addFlushCacheModel(this.state.applyNamespace(cacheModel));
        }
        this.state.getConfig().getErrorContext().setMoreInfo(null);
    }
}

