/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.SqlSource;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandlerFactory;
import com.ibatis.sqlmap.engine.mapping.sql.raw.RawSql;
import java.util.Properties;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSqlSource
implements SqlSource {
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();
    private XmlParserState state;
    private Node parentNode;

    public XMLSqlSource(XmlParserState config, Node parentNode) {
        this.state = config;
        this.parentNode = parentNode;
    }

    @Override
    public Sql getSql() {
        this.state.getConfig().getErrorContext().setActivity("processing an SQL statement");
        boolean isDynamic = false;
        StringBuilder sqlBuffer = new StringBuilder();
        DynamicSql dynamic = new DynamicSql(this.state.getConfig().getClient().getDelegate());
        isDynamic = this.parseDynamicTags(this.parentNode, dynamic, sqlBuffer, isDynamic, false);
        if (isDynamic) {
            return dynamic;
        }
        String sqlStatement = sqlBuffer.toString();
        return new RawSql(sqlStatement);
    }

    private boolean parseDynamicTags(Node node, DynamicParent dynamic, StringBuilder sqlBuffer, boolean isDynamic, boolean postParseRequired) {
        this.state.getConfig().getErrorContext().setActivity("parsing dynamic SQL tags");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                SqlText sqlText;
                String data = ((CharacterData)child).getData();
                data = SqlText.cleanSql(data, i == 0 && this.parentNode == node);
                data = NodeletUtils.parsePropertyTokens(data, this.state.getGlobalProps());
                if (postParseRequired) {
                    sqlText = new SqlText();
                    sqlText.setPostParseRequired(postParseRequired);
                    sqlText.setText(data);
                } else {
                    sqlText = PARAM_PARSER.parseInlineParameterMap(this.state.getConfig().getClient().getDelegate().getTypeHandlerFactory(), data, null);
                    sqlText.setPostParseRequired(postParseRequired);
                }
                if (sqlText.isWhiteSpace()) continue;
                dynamic.addChild(sqlText);
                sqlBuffer.append(data);
                continue;
            }
            if ("include".equals(nodeName)) {
                Properties attributes = NodeletUtils.parseAttributes(child, this.state.getGlobalProps());
                String refid = (String)attributes.get("refid");
                Node includeNode = this.state.getSqlIncludes().get(refid);
                if (includeNode == null) {
                    String nsrefid = this.state.applyNamespace(refid);
                    includeNode = this.state.getSqlIncludes().get(nsrefid);
                    if (includeNode == null) {
                        throw new RuntimeException("Could not find SQL statement to include with refid '" + refid + "'");
                    }
                }
                isDynamic = this.parseDynamicTags(includeNode, dynamic, sqlBuffer, isDynamic, false);
                continue;
            }
            this.state.getConfig().getErrorContext().setMoreInfo("Check the dynamic tags.");
            SqlTagHandler handler = SqlTagHandlerFactory.getSqlTagHandler(nodeName);
            if (handler == null) continue;
            isDynamic = true;
            Properties ps = NodeletUtils.parseAttributes(child, this.state.getGlobalProps());
            SqlTag tag = new SqlTag(ps.hashCode());
            tag.setName(nodeName);
            tag.setHandler(handler);
            tag.setPrependAttr(XMLSqlSource.prop(ps, "prepend", "pre"));
            tag.setPropertyAttr(XMLSqlSource.prop(ps, "property", "p"));
            tag.setRemoveFirstPrepend(XMLSqlSource.prop(ps, "removeFirstPrepend", "rm"));
            tag.setOpenAttr(XMLSqlSource.prop(ps, "open", "o"));
            tag.setCloseAttr(XMLSqlSource.prop(ps, "close", "c"));
            tag.setComparePropertyAttr(XMLSqlSource.prop(ps, "compareProperty", "cp"));
            tag.setCompareValueAttr(XMLSqlSource.prop(ps, "compareValue", "cv"));
            tag.setConjunctionAttr(XMLSqlSource.prop(ps, "conjunction", "conj"));
            if (dynamic instanceof SqlTag) {
                SqlTag parentSqlTag = (SqlTag)dynamic;
                if (parentSqlTag.isPostParseRequired() || tag.getHandler() instanceof IterateTagHandler) {
                    tag.setPostParseRequired(true);
                }
            } else if (dynamic instanceof DynamicSql && tag.getHandler() instanceof IterateTagHandler) {
                tag.setPostParseRequired(true);
            }
            dynamic.addChild(tag);
            if (!child.hasChildNodes()) continue;
            isDynamic = this.parseDynamicTags(child, tag, sqlBuffer, isDynamic, tag.isPostParseRequired());
        }
        this.state.getConfig().getErrorContext().setMoreInfo(null);
        return isDynamic;
    }

    static String prop(Properties ps, String key, String alias) {
        return ps.getProperty(key, ps.getProperty(alias));
    }
}

