/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.config.CacheModelConfig;
import com.ibatis.sqlmap.engine.config.ParameterMapConfig;
import com.ibatis.sqlmap.engine.config.ResultMapConfig;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.ibatis.client.Dialect;
import org.w3c.dom.Node;

public class XmlParserState {
    private static final ILog log = ILogFactory.getLog(XmlParserState.class);
    private SqlMapConfiguration config = new SqlMapConfiguration(this);
    private final Properties globalProps = new Properties(System.getProperties());
    private final Properties txProps = new Properties();
    private final Properties dsProps = new Properties();
    private final Properties cacheProps = new Properties();
    private boolean useStatementNamespaces = false;
    private Map<String, Node> sqlIncludes = new HashMap<String, Node>();
    private ParameterMapConfig paramConfig;
    private ResultMapConfig resultConfig;
    private CacheModelConfig cacheConfig;
    private String namespace;
    private DataSource dataSource;
    private Dialect dialect;
    Map<String, String> parsedResources = new LinkedHashMap<String, String>();

    public SqlMapConfiguration getConfig() {
        return this.config;
    }

    public void setGlobalProps(Properties props) {
        if (props != null) {
            String className = this.globalProps.getProperty("sql_executor_class");
            this.globalProps.putAll((Map<?, ?>)props);
            this.txProps.putAll((Map<?, ?>)props);
            this.dsProps.putAll((Map<?, ?>)props);
            String customizedSQLExecutor = this.globalProps.getProperty("sql_executor_class");
            this.config.getErrorContext().setActivity("Loading SQLExecutor.");
            if (customizedSQLExecutor != null && !customizedSQLExecutor.equals(className)) {
                try {
                    this.config.getClient().getDelegate().setCustomExecutor(customizedSQLExecutor);
                    this.config.getClient().getDelegate().getSqlExecutor().init(this.config, this.globalProps);
                }
                catch (Exception e) {
                    this.config.getErrorContext().setCause(e);
                    this.config.getErrorContext().setMoreInfo("Loading of customizedSQLExecutor failed. Please check Properties file.");
                }
            }
        }
    }

    public Properties getGlobalProps() {
        return this.globalProps;
    }

    public Properties getTxProps() {
        return this.txProps;
    }

    public Properties getDsProps() {
        return this.dsProps;
    }

    public Properties getCacheProps() {
        return this.cacheProps;
    }

    public void setUseStatementNamespaces(boolean useStatementNamespaces) {
        this.useStatementNamespaces = useStatementNamespaces;
    }

    public boolean isUseStatementNamespaces() {
        return this.useStatementNamespaces;
    }

    public Map<String, Node> getSqlIncludes() {
        return this.sqlIncludes;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String applyNamespace(String id) {
        String newId = id;
        if (this.namespace != null && this.namespace.length() > 0 && id != null && id.indexOf(46) < 0) {
            newId = this.namespace + "." + id;
        }
        return newId;
    }

    public CacheModelConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheModelConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public ParameterMapConfig getParamConfig() {
        return this.paramConfig;
    }

    public void setParamConfig(ParameterMapConfig paramConfig) {
        this.paramConfig = paramConfig;
    }

    public ResultMapConfig getResultConfig() {
        return this.resultConfig;
    }

    public void setResultConfig(ResultMapConfig resultConfig) {
        this.resultConfig = resultConfig;
    }

    public void setGlobalProperties(String resource, String url) {
        this.config.getErrorContext().setActivity("loading global properties");
        try {
            Properties props;
            if (resource != null) {
                this.config.getErrorContext().setResource(resource);
                props = Resources.getResourceAsProperties(resource);
            } else if (url != null) {
                this.config.getErrorContext().setResource(url);
                props = Resources.getUrlAsProperties(url);
            } else {
                throw new RuntimeException("The properties element requires either a resource or a url attribute.");
            }
            if (props != null) {
                props.putAll((Map<?, ?>)this.globalProps);
                this.setGlobalProps(props);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading properties.  Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void addSqlMapResource(String resource) {
        if (this.parsedResources.put(resource, "") != null) {
            log.warn("Maybe re-parse sqlmap resource: " + resource);
        } else {
            log.debug("Parse mapping resource -> " + resource);
        }
    }
}

