/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CacheKey
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4723868979183352847L;
    private static final int DEFAULT_MULTIPLYER = 37;
    private static final int DEFAULT_HASHCODE = 17;
    private int hashcode = 17;
    private long checksum;
    private int count = 0;
    private List<Object> paramList = new ArrayList<Object>();

    public CacheKey update(Object object) {
        if (object instanceof Class) {
            object = object.toString();
        }
        int baseHashCode = object == null ? 17 : object.hashCode();
        ++this.count;
        this.checksum += (long)baseHashCode;
        this.hashcode = 37 * this.hashcode + (baseHashCode *= this.count);
        this.paramList.add(object);
        return this;
    }

    public CacheKey update(Object[] objects) {
        if (objects == null) {
            this.update((Object)null);
        } else {
            this.update(Arrays.asList(objects).toString());
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        if (this.hashcode != cacheKey.hashcode) {
            return false;
        }
        if (this.checksum != cacheKey.checksum) {
            return false;
        }
        if (this.count != cacheKey.count) {
            return false;
        }
        for (int i = 0; i < this.paramList.size(); ++i) {
            Object thisParam = this.paramList.get(i);
            Object thatParam = cacheKey.paramList.get(i);
            if (!(thisParam == null ? thatParam != null : !thisParam.equals(thatParam))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toStr() {
        return Integer.toHexString(this.hashcode);
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder().append(this.hashcode).append('|').append(this.checksum);
        for (int i = 0; i < this.paramList.size(); ++i) {
            String str = String.valueOf(this.paramList.get(i));
            if (str.length() > 72) {
                str = str.substring(0, 30) + "..." + str.substring(str.length() - 30);
            }
            returnValue.append('|').append(str);
        }
        return returnValue.toString();
    }

    public CacheKey clone() throws CloneNotSupportedException {
        CacheKey ck = (CacheKey)super.clone();
        ck.paramList = new ArrayList<Object>(this.paramList);
        return ck;
    }
}

