/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import com.ibatis.common.ArraySet;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.FlushListener;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ibatis.client.Cache;

public class CacheModel
implements Cache,
FlushListener {
    private static final ILog log = ILogFactory.getLog(CacheModel.class);
    private static final int MAX_OBJECT_LOG_SIZE = 32;
    private long requests = 0L;
    private long hits = 0L;
    private long flushs = 0L;
    private String id;
    private int maxCacheSize = -1;
    private long lastFlush;
    private long flushInterval = -1L;
    private long flushIntervalSeconds = -1L;
    private Set<String> flushTriggerRoots;
    private Set<String> flushTriggerStatements;
    private Set<String> flushTriggerCaches;
    private Set<Class<?>> flushTriggerEntityClasses;
    private CacheController controller;
    private String resource;
    private Set<FlushListener> flushListeners = new ArraySet<FlushListener>();

    public CacheModel() {
        this.lastFlush = System.currentTimeMillis();
        this.flushTriggerRoots = new ArraySet<String>();
        this.flushTriggerStatements = new ArraySet<String>();
        this.flushTriggerCaches = new ArraySet<String>();
        this.flushTriggerEntityClasses = new ArraySet();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheController(CacheController controller) {
        this.controller = controller;
    }

    public CacheController getCacheController() {
        return this.controller;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public long getFlushIntervalSeconds() {
        return this.flushIntervalSeconds;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        this.flushIntervalSeconds = flushInterval / 1000L;
    }

    public void addFlushTriggerRoot(String name) {
        this.flushTriggerRoots.add(name);
    }

    public void addFlushTriggerStatement(String statementName) {
        this.flushTriggerStatements.add(statementName);
    }

    public void addFlushTriggerCache(String cacheId) {
        this.flushTriggerCaches.add(cacheId);
    }

    public void addFlushTriggerEntityClass(Class<?> clazz) {
        this.flushTriggerEntityClasses.add(clazz);
    }

    public Set<String> getFlushTriggerCacheRoots() {
        return this.flushTriggerRoots;
    }

    public Set<String> getFlushTriggerStatementNames() {
        return this.flushTriggerStatements;
    }

    public Set<String> getFlushTriggerCacheNames() {
        return this.flushTriggerCaches;
    }

    public Set<Class<?>> getFlushTriggerEntityClasses() {
        return this.flushTriggerEntityClasses;
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public void configure(Properties props) {
        this.controller.setProperties(this, props);
    }

    @Override
    public void flush() {
        this.doFlush(System.currentTimeMillis());
    }

    synchronized void doFlush(long timestamp) {
        this.controller.flush(this);
        this.lastFlush = timestamp;
        ++this.flushs;
        if (log.isTraceEnabled()) {
            this.log("flushed", false, null);
        }
        for (FlushListener fl : this.flushListeners) {
            fl.onFlush(this.id, timestamp);
        }
    }

    @Override
    public void onFlush(String id, long timestamp) {
        if (this.lastFlush < timestamp) {
            this.doFlush(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(Object key) {
        Object value = null;
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            long curr = System.currentTimeMillis();
            if (this.flushInterval > 0L && curr - this.lastFlush > this.flushInterval) {
                this.controller.flush(this);
                this.lastFlush = curr;
                ++this.flushs;
            }
            value = this.controller.getObject(this, key);
            ++this.requests;
            if (value != null) {
                ++this.hits;
            }
            if (log.isTraceEnabled()) {
                if (value != null) {
                    this.log("retrieved #" + key, false, null);
                } else {
                    this.log("cache miss #" + key, false, null);
                }
            }
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object key, Object value) {
        if (null == value) {
            value = NULL_OBJECT;
        }
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            this.controller.putObject(this, key, value);
            if (log.isTraceEnabled()) {
                this.log("stored object #" + key, true, value);
            }
        }
    }

    protected int getMaxObjectLogSize() {
        return 32;
    }

    protected void log(String action, boolean addValue, Object cacheValue) {
        StringBuilder output = new StringBuilder("Cache '");
        output.append(this.getId());
        output.append("': ");
        output.append(action);
        if (addValue) {
            String cacheObjectStr = cacheValue == null ? "null" : this.toStr(cacheValue);
            output.append(" '");
            if (cacheObjectStr.length() < this.getMaxObjectLogSize()) {
                output.append(cacheObjectStr.toString());
            } else {
                output.append(cacheObjectStr.substring(0, this.getMaxObjectLogSize()));
                output.append("...");
            }
            output.append("'");
        }
        log.trace(output.toString());
    }

    String toStr(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            if (list.isEmpty()) {
                return "[]";
            }
            return "[ " + list.size() + " ) " + list.get(0) + "]";
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.isEmpty()) {
                return "{}";
            }
            return "{ " + map.size() + " ) " + map.entrySet().iterator().next() + "}";
        }
        return o.toString();
    }

    public void setControllerProperties(Properties cacheProps) {
        this.controller.setProperties(this, cacheProps);
    }

    @Override
    public long getRequests() {
        return this.requests;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getFlushs() {
        return this.flushs;
    }

    @Override
    public long getPeriodMillis() {
        return System.currentTimeMillis() - this.lastFlush;
    }

    public String toString() {
        return "CacheModel [" + this.id + ", " + this.hits + " / " + this.requests + ", " + this.getPeriodMillis() / 1000L + "]";
    }

    public synchronized void addFlushListener(FlushListener listener) {
        this.flushListeners.add(listener);
    }

    public synchronized void removeFlushListener(FlushListener listener) {
        this.flushListeners.remove(listener);
    }
}

