/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import com.ibatis.common.ArraySet;
import com.ibatis.sqlmap.engine.cache.FlushListener;
import java.util.Set;

public final class CacheRoot
implements FlushListener {
    final String id;
    long lastFlush = 0L;
    long flushCount = 0L;
    boolean real;
    Set<FlushListener> flushListeners = new ArraySet<FlushListener>();

    CacheRoot(String id, boolean real) {
        this.id = id;
        this.real = real;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootChanged(long time) {
        if (time > this.lastFlush) {
            this.lastFlush = time;
            ++this.flushCount;
            Set<FlushListener> set = this.flushListeners;
            synchronized (set) {
                for (FlushListener f : this.flushListeners) {
                    f.onFlush(this.id, time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlushListener(FlushListener l) {
        Set<FlushListener> set = this.flushListeners;
        synchronized (set) {
            this.flushListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<FlushListener> set = this.flushListeners;
        synchronized (set) {
            this.flushListeners.clear();
        }
    }

    @Override
    public void onFlush(String id, long t) {
        this.rootChanged(t);
    }

    public long getLastFlush() {
        return this.lastFlush;
    }

    public long getFlushCount() {
        return this.flushCount;
    }

    public String getId() {
        return this.id;
    }

    public boolean isReal() {
        return this.real;
    }
}

