/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import com.ibatis.sqlmap.engine.cache.CacheRoot;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheRoots {
    Map<String, CacheRoot> roots = new ConcurrentHashMap<String, CacheRoot>();

    public void flushRoots(long timestamp, String name) {
        CacheRoot root = this.roots.get(name.toLowerCase().trim());
        if (root != null) {
            root.rootChanged(timestamp);
        } else {
            root = new CacheRoot(name, false);
            this.roots.put(name, root);
            root.rootChanged(timestamp);
        }
    }

    public void flushRoots(long timestamp, String ... names) {
        for (String name : names) {
            this.flushRoots(timestamp, name);
        }
    }

    public void flushRoots(String name) {
        this.flushRoots(System.currentTimeMillis(), name);
    }

    public void flushRoots(String ... names) {
        this.flushRoots(System.currentTimeMillis(), names);
    }

    public CacheRoot makeRoot(String name) {
        CacheRoot root = this.roots.get(name = name.toLowerCase().trim());
        if (root == null) {
            root = new CacheRoot(name, true);
            this.roots.put(name, root);
        } else {
            root.real = true;
        }
        return root;
    }

    public void reset(boolean all) {
        Map<String, CacheRoot> old = this.roots;
        if (all) {
            this.roots = new ConcurrentHashMap<String, CacheRoot>();
        }
        for (CacheRoot root : old.values()) {
            root.clear();
        }
    }

    public CacheRoot[] getRoots() {
        return this.roots.values().toArray(new CacheRoot[0]);
    }
}

