/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.ehcache;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheController
implements CacheController {
    private static volatile CacheManager cacheManager;
    private static final AtomicInteger refCounter;

    @Override
    public void flush(CacheModel cacheModel) {
        this.getCache(cacheModel).removeAll();
    }

    @Override
    public Object getObject(CacheModel cacheModel, Object key) {
        Object result = null;
        Element element = this.getCache(cacheModel).get(key);
        if (element != null) {
            result = element.getObjectValue();
        }
        return result;
    }

    @Override
    public void putObject(CacheModel cacheModel, Object key, Object object) {
        this.getCache(cacheModel).put(new Element(key, object));
    }

    @Override
    public Object removeObject(CacheModel cacheModel, Object key) {
        Object result = this.getObject(cacheModel, key);
        this.getCache(cacheModel).remove(key);
        return result;
    }

    @Override
    public void setProperties(CacheModel cacheModel, Properties props) {
        refCounter.incrementAndGet();
        if (cacheManager == null) {
            URL url;
            String configLocation = props.getProperty("ehcacheConfigLocaion");
            if (configLocation == null) {
                configLocation = "/ehcache.xml";
            }
            cacheManager = (url = this.getClass().getResource(configLocation)) != null ? CacheManager.create((URL)url) : CacheManager.create();
        }
    }

    private Cache getCache(CacheModel cacheModel) {
        String cacheName = cacheModel.getId();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cacheManager.addCache(cacheName);
            cache = cacheManager.getCache(cacheName);
        }
        return cache;
    }

    public void finalize() {
        if (refCounter.decrementAndGet() < 1) {
            if (cacheManager != null) {
                cacheManager.shutdown();
            }
            cacheManager = null;
        }
    }

    static {
        refCounter = new AtomicInteger();
    }
}

