/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.memory;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCacheJGroupsBroadcastor;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCacheLevel;
import com.ibatis.sqlmap.engine.cache.memory.MulticastorBase;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryCache {
    static final ILog log = ILogFactory.getLog(MemoryCache.class);
    ConcurrentHashMap<String, LRUMap> cache = new ConcurrentHashMap();
    MulticastorBase multicast;
    static final MemoryCache Instance = new MemoryCache();

    MemoryCache() {
        Properties p = Resources.getIbatisIniProperties();
        if (!"true".equals(p.getProperty("memory.mcast.enable"))) {
            return;
        }
        this.multicast = new MemoryCacheJGroupsBroadcastor();
        this.multicast.init(this);
    }

    LRUMap cache(String id) {
        LRUMap map = this.cache.get(id);
        if (map == null) {
            map = new LRUMap();
            this.cache.put(id, map);
        }
        return map;
    }

    public void setCacheSize(CacheModel cacheModel, int val) {
        this.cache(cacheModel.getId()).setMaxCacheSize(val);
    }

    public Object getEntry(CacheModel cacheModel, Object key) {
        return this.cache(cacheModel.getId()).getObject(key);
    }

    public void putEntry(CacheModel cm, MemoryCacheLevel lvl, Object key, Object value) {
        CacheEntry ce = new CacheEntry(System.currentTimeMillis() + cm.getFlushInterval(), lvl, value);
        this.cache(cm.getId()).put(key, ce);
    }

    public Object removeEntry(CacheModel cacheModel, Object key) {
        CacheEntry ce = this.cache(cacheModel.getId()).remove(key);
        return ce == null ? null : ce.get();
    }

    public void flushGroup(String id) {
        LRUMap map = this.cache.get(id);
        if (map != null) {
            map.clear();
            if (this.multicast != null) {
                this.multicast.multicastFlush(id);
            }
        }
    }

    public static MemoryCache getInstance() {
        return Instance;
    }

    static class CacheEntry {
        private Object object;
        private final boolean ref;
        private long expiredTime;

        public CacheEntry(long expiredTime, MemoryCacheLevel level, Object object) {
            this.expiredTime = expiredTime;
            boolean bl = this.ref = level != MemoryCacheLevel.STRONG;
            this.object = level == MemoryCacheLevel.STRONG ? object : (level == MemoryCacheLevel.SOFT ? new SoftReference<Object>(object) : new WeakReference<Object>(object));
        }

        public Object get() {
            if (this.expiredTime < System.currentTimeMillis()) {
                return null;
            }
            if (this.ref) {
                return ((Reference)this.object).get();
            }
            return this.object;
        }
    }

    static class LRUMap
    extends LinkedHashMap<Object, CacheEntry> {
        private static final long serialVersionUID = 4058604680659857139L;
        int maxCacheSize = 512;

        LRUMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, CacheEntry> eldest) {
            return this.maxCacheSize > 0 && this.size() > this.maxCacheSize;
        }

        public synchronized Object getObject(Object key) {
            CacheEntry ce = (CacheEntry)super.get(key);
            if (ce != null) {
                Object value = ce.get();
                if (value == null) {
                    super.remove(key);
                    return null;
                }
                super.put(key, ce);
                return value;
            }
            return null;
        }

        @Override
        public synchronized CacheEntry put(Object key, CacheEntry value) {
            return super.put(key, value);
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        public synchronized CacheEntry remove(Object key) {
            return (CacheEntry)super.remove(key);
        }

        public int getMaxCacheSize() {
            return this.maxCacheSize;
        }

        public void setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
        }
    }
}

