/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.memory;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCache;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCacheLevel;
import java.util.Properties;

public class MemoryCacheController
implements CacheController {
    private MemoryCacheLevel referenceType = MemoryCacheLevel.STRONG;

    @Override
    public void setProperties(CacheModel cacheModel, Properties props) {
        String mcs;
        String refType = props.getProperty("reference-type");
        if (refType == null) {
            refType = props.getProperty("referenceType");
        }
        if (refType != null) {
            this.referenceType = MemoryCacheLevel.getByReferenceType(refType);
        }
        if ((mcs = props.getProperty("memory.cache.size")) != null) {
            try {
                int val = Integer.parseInt(mcs);
                MemoryCache.getInstance().setCacheSize(cacheModel, val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MemoryCacheLevel getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(MemoryCacheLevel referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    public void putObject(CacheModel cacheModel, Object key, Object value) {
        MemoryCache.getInstance().putEntry(cacheModel, this.referenceType, key, value);
    }

    @Override
    public Object getObject(CacheModel cacheModel, Object key) {
        return MemoryCache.getInstance().getEntry(cacheModel, key);
    }

    @Override
    public Object removeObject(CacheModel cacheModel, Object key) {
        return MemoryCache.getInstance().removeEntry(cacheModel, key);
    }

    @Override
    public void flush(CacheModel cacheModel) {
        MemoryCache.getInstance().flushGroup(cacheModel.getId());
    }
}

