/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.memory;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCache;
import com.ibatis.sqlmap.engine.cache.memory.MulticastorBase;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibatis.jgroups.oscache.NotificationBus;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;

public class MemoryCacheJGroupsBroadcastor
extends MulticastorBase
implements NotificationBus.Consumer {
    private static final Log log = LogFactory.getLog(MemoryCacheJGroupsBroadcastor.class);
    private static final String BUS_NAME = "MemoryCacheBus";
    private static final String CHANNEL_PROPERTIES = "memory.mcast.properties";
    private static final String MULTICAST_IP_PROPERTY = "memory.mcast.addr";
    private static final String MULTICAST_PORT_PROPERTY = "memory.mcast.port";
    private static final String DEFAULT_CHANNEL_PROPERTIES_PRE = "UDP(mcast_addr=";
    private static final String DEFAULT_CHANNEL_PROPERTIES_MID = ";mcast_port=";
    private static final String DEFAULT_CHANNEL_PROPERTIES_LAST = ";):PING:MERGE2:FD_SOCK:VERIFY_SUSPECT:pbcast.NAKACK:UNICAST:pbcast.STABLE:FRAG:pbcast.GMS";
    private static final String DEFAULT_MULTICAST_IP = "231.6.7.8";
    private static final String DEFAULT_MULTICAST_PORT = "44566";
    private NotificationBus bus;
    private MemoryCache memoryCache;

    @Override
    public void init(MemoryCache memoryCache) {
        this.memoryCache = memoryCache;
        Properties p = Resources.getIbatisIniProperties();
        String properties = p.getProperty(CHANNEL_PROPERTIES);
        String multicastIP = p.getProperty(MULTICAST_IP_PROPERTY);
        String multicastPort = p.getProperty(MULTICAST_PORT_PROPERTY);
        if (properties == null && multicastIP == null) {
            multicastIP = DEFAULT_MULTICAST_IP;
        }
        if (properties == null) {
            if (multicastIP == null) {
                multicastIP = DEFAULT_MULTICAST_IP;
            }
            if (multicastPort == null) {
                multicastPort = DEFAULT_MULTICAST_PORT;
            }
            properties = DEFAULT_CHANNEL_PROPERTIES_PRE + multicastIP.trim() + DEFAULT_CHANNEL_PROPERTIES_MID + multicastPort.trim() + DEFAULT_CHANNEL_PROPERTIES_LAST;
        } else {
            properties = properties.trim();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting a new JGroups broadcasting listener with properties=" + properties));
        }
        try {
            JChannel ch = new JChannel(properties);
            this.setDiscardOwnMessages(ch);
            this.bus = new NotificationBus((Channel)ch, BUS_NAME);
            this.bus.start();
            this.bus.setConsumer(this);
            log.info((Object)"JGroups clustering support started successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization failed: " + e);
        }
    }

    void setDiscardOwnMessages(JChannel ch) {
        Method m = null;
        try {
            m = ch.getClass().getMethod("setDiscardOwnMessages", Boolean.TYPE);
            m.invoke((Object)ch, false);
            return;
        }
        catch (Exception exception) {
            try {
                m = ch.getClass().getMethod("setOpt", Integer.TYPE, Object.class);
                m.invoke((Object)ch, 3, Boolean.FALSE);
                return;
            }
            catch (Exception exception2) {
                log.warn((Object)"JGroups channel setDiscardOwnMessages() failed.");
                return;
            }
        }
    }

    public synchronized void finialize() {
        this.close();
    }

    @Override
    public void handleNotification(Serializable info) {
        if (info instanceof String) {
            String cacheId = (String)((Object)info);
            this.onMulticastFlush(cacheId);
            return;
        }
        log.error((Object)("An unknown cluster notification message received (class=" + info.getClass().getName() + "). Notification ignored."));
    }

    @Override
    public Serializable getCache() {
        return this.getClass().getSimpleName() + ": " + this.bus.getLocalAddress();
    }

    @Override
    public void memberJoined(Address address) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A new member at address '" + address + "' has joined the cluster"));
        }
    }

    @Override
    public void memberLeft(Address address) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Member at address '" + address + "' left the cluster"));
        }
    }

    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)"JGroups shutting down...");
        }
        if (this.bus != null) {
            this.bus.stop();
            this.bus = null;
        } else {
            log.warn((Object)"Notification bus wasn't initialized or finialize was invoked before!");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"JGroups shutdown complete.");
        }
    }

    @Override
    public void multicastFlush(String cacheId) {
        if (this.bus != null) {
            this.bus.sendNotification((Serializable)((Object)cacheId));
        }
    }

    @Override
    public void onMulticastFlush(String cacheId) {
        this.memoryCache.cache(cacheId).clear();
        if (MemoryCache.log.isDebugEnabled()) {
            MemoryCache.log.debug(cacheId + " cache flushed.");
        }
    }
}

