/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.oscache;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Properties;

public class OSCacheController
implements CacheController {
    @Override
    public void flush(CacheModel cacheModel) {
        OSCache.CACHE.flushGroup(cacheModel.getId());
    }

    @Override
    public Object getObject(CacheModel cacheModel, Object key) {
        String keyString = key.toString();
        try {
            int refreshPeriod = (int)cacheModel.getFlushIntervalSeconds();
            return OSCache.CACHE.getFromCache(keyString, refreshPeriod);
        }
        catch (NeedsRefreshException e) {
            OSCache.CACHE.cancelUpdate(keyString);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeObject(CacheModel cacheModel, Object key) {
        Object result;
        String keyString = key.toString();
        try {
            int refreshPeriod = (int)cacheModel.getFlushIntervalSeconds();
            Object value = OSCache.CACHE.getFromCache(keyString, refreshPeriod);
            if (value != null) {
                OSCache.CACHE.flushEntry(keyString);
            }
            result = value;
        }
        catch (NeedsRefreshException e) {
            try {
                OSCache.CACHE.flushEntry(keyString);
            }
            finally {
                OSCache.CACHE.cancelUpdate(keyString);
                result = null;
            }
        }
        return result;
    }

    @Override
    public void putObject(CacheModel cacheModel, Object key, Object object) {
        String keyString = key.toString();
        OSCache.CACHE.putInCache(keyString, object, new String[]{cacheModel.getId()});
    }

    @Override
    public void setProperties(CacheModel cacheModel, Properties props) {
    }

    static class OSCache {
        static final GeneralCacheAdministrator CACHE = new GeneralCacheAdministrator();

        OSCache() {
        }
    }
}

