/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import java.util.Properties;

public class CacheModelConfig {
    private ErrorContext errorContext;
    private CacheModel cacheModel;

    CacheModelConfig(SqlMapConfiguration config, String id, CacheController controller) {
        this.errorContext = config.getErrorContext();
        this.cacheModel = new CacheModel();
        SqlMapClientImpl client = config.getClient();
        this.errorContext.setActivity("building a cache model");
        this.errorContext.setObjectId(id + " cache model");
        this.errorContext.setMoreInfo("Check the cache model type.");
        this.cacheModel.setId(id);
        this.cacheModel.setResource(this.errorContext.getResource());
        this.cacheModel.setCacheController(controller);
        this.errorContext.setMoreInfo("Check the cache model configuration.");
        if (client.getDelegate().isCacheModelsEnabled()) {
            client.getDelegate().addCacheModel(this.cacheModel);
        }
        this.errorContext.setMoreInfo(null);
        this.errorContext.setObjectId(null);
    }

    public void setFlushInterval(long hours, long minutes, long seconds, long milliseconds) {
        this.errorContext.setMoreInfo("Check the cache model flush interval.");
        long t = 0L;
        t += milliseconds;
        t += seconds * 1000L;
        t += minutes * 60L * 1000L;
        if ((t += hours * 60L * 60L * 1000L) < 1L) {
            throw new RuntimeException("A flush interval must specify one or more of milliseconds, seconds, minutes or hours.");
        }
        this.cacheModel.setFlushInterval(t);
    }

    public void addFlushTriggerStatement(String statement) {
        this.errorContext.setMoreInfo("Check the cache model flush on statement elements.");
        this.cacheModel.addFlushTriggerStatement(statement);
    }

    public void addFlushTriggerRoot(String name) {
        this.cacheModel.addFlushTriggerRoot(name);
    }

    public void addFlushTriggerCache(String cacheId) {
        this.errorContext.setMoreInfo("Check the cache model flush on cache flush.");
        this.cacheModel.addFlushTriggerCache(cacheId);
    }

    public void addFlushTriggerEntityClass(Class<?> clazz) {
        this.errorContext.setMoreInfo("Check the cache model flush on entity flush.");
        this.cacheModel.addFlushTriggerEntityClass(clazz);
    }

    public CacheModel getCacheModel() {
        return this.cacheModel;
    }

    public void setControllerProperties(Properties cacheProps) {
        this.cacheModel.setControllerProperties(cacheProps);
    }
}

