/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.NoneCacheController;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.config.SqlSource;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.stat.StaticSql;
import com.ibatis.sqlmap.engine.mapping.statement.CachingStatement;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.Arrays;
import java.util.List;

public class MappedStatementConfig {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();
    private ErrorContext errorContext;
    private SqlMapClientImpl client;
    private TypeHandlerFactory typeHandlerFactory;
    private MappedStatement mappedStatement;
    private MappedStatement rootStatement;

    MappedStatementConfig(SqlMapConfiguration config, String id, MappedStatement statement, SqlSource processor, String parameterMapName, Class<?> parameterClass, String resultMapName, String[] additionalResultMapNames, Class<?> resultClass, Class<?>[] additionalResultClasses, String cacheModelName, String resultSetType, Integer fetchSize, boolean allowRemapping, Integer timeout, Integer defaultStatementTimeout, boolean canBatch) {
        CacheModel cacheModel;
        ParameterMap parameterMap;
        this.errorContext = config.getErrorContext();
        this.client = config.getClient();
        SqlMapExecutorDelegate delegate = this.client.getDelegate();
        this.typeHandlerFactory = config.getTypeHandlerFactory();
        this.errorContext.setActivity("parsing a mapped statement");
        this.errorContext.setObjectId(id + " statement");
        this.errorContext.setMoreInfo("Check the result map name.");
        if (resultMapName != null) {
            statement.setResultMap(this.client.getDelegate().getResultMap(resultMapName));
            if (additionalResultMapNames != null) {
                for (int i = 0; i < additionalResultMapNames.length; ++i) {
                    statement.addResultMap(this.client.getDelegate().getResultMap(additionalResultMapNames[i]));
                }
            }
        }
        this.errorContext.setMoreInfo("Check the parameter map name.");
        if (parameterMapName != null) {
            statement.setParameterMap(this.client.getDelegate().getParameterMap(parameterMapName));
        }
        statement.setId(id);
        statement.setCanBatch(canBatch);
        statement.setResource(this.errorContext.getResource());
        if (resultSetType != null) {
            if ("FORWARD_ONLY".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1003));
            } else if ("SCROLL_INSENSITIVE".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1004));
            } else if ("SCROLL_SENSITIVE".equals(resultSetType)) {
                statement.setResultSetType(new Integer(1005));
            }
        }
        if (fetchSize != null) {
            statement.setFetchSize(fetchSize);
        }
        if ((parameterMap = statement.getParameterMap()) == null) {
            statement.setParameterClass(parameterClass);
        } else {
            statement.setParameterClass(parameterMap.getParameterClass());
        }
        this.errorContext.setMoreInfo("Check the SQL statement.");
        Sql sql = processor.getSql();
        this.setSqlForStatement(statement, sql);
        ResultMap resultMap = statement.getResultMap();
        if (resultMap == null && resultClass == null) {
            statement.setResultMap(null);
        } else if (resultMap == null) {
            resultMap = this.buildAutoResultMap(allowRemapping, statement, resultClass);
            statement.setResultMap(resultMap);
            if (additionalResultClasses != null) {
                for (int i = 0; i < additionalResultClasses.length; ++i) {
                    statement.addResultMap(this.buildAutoResultMap(allowRemapping, statement, additionalResultClasses[i]));
                }
            }
        }
        statement.setTimeout(defaultStatementTimeout);
        if (timeout != null) {
            try {
                statement.setTimeout(timeout);
            }
            catch (NumberFormatException e) {
                throw new SqlMapException("Specified timeout value for statement " + statement.getId() + " is not a valid integer");
            }
        }
        this.errorContext.setMoreInfo(null);
        this.errorContext.setObjectId(null);
        statement.setDelegate(delegate);
        this.mappedStatement = cacheModelName != null && cacheModelName.length() > 0 && this.client.getDelegate().isCacheModelsEnabled() ? ((cacheModel = this.client.getDelegate().getCacheModel(cacheModelName)).getCacheController() == NoneCacheController.INSTANCE ? statement : new CachingStatement(statement, cacheModel)) : statement;
        this.rootStatement = statement;
        CacheKey msKey = new CacheKey();
        msKey.update(id);
        msKey.update(sql.hashCodex());
        msKey.update(parameterMapName);
        msKey.update(parameterClass);
        msKey.update(resultMapName);
        msKey.update(additionalResultMapNames);
        msKey.update(resultClass);
        msKey.update(additionalResultClasses);
        msKey.update(cacheModelName);
        msKey.update(resultSetType);
        msKey.update(fetchSize);
        msKey.update(allowRemapping);
        msKey.update(statement.getTimeout());
        msKey.update(canBatch);
        delegate.addMappedStatement(this.mappedStatement, msKey.hashCode());
    }

    public void setSelectKeyStatement(SqlSource processor, String resultClassName, String keyPropName, boolean runAfterSQL, boolean genKey) {
        Class<Object> resultClass;
        SelectKeyStatement selectKeyStatement;
        InsertStatement insertStatement;
        if (this.rootStatement instanceof InsertStatement) {
            insertStatement = (InsertStatement)this.rootStatement;
            Class<?> parameterClass = insertStatement.getParameterClass();
            this.errorContext.setActivity("parsing a select key");
            selectKeyStatement = new SelectKeyStatement();
            resultClassName = this.typeHandlerFactory.resolveAlias(resultClassName);
            resultClass = null;
            selectKeyStatement.setDelegate(this.client.getDelegate());
            selectKeyStatement.setId(insertStatement.getId() + "-SelectKey");
            selectKeyStatement.setResource(this.errorContext.getResource());
            selectKeyStatement.setKeyProperty(keyPropName);
            selectKeyStatement.setRunAfterSQL(runAfterSQL);
            try {
                if (resultClassName != null) {
                    this.errorContext.setMoreInfo("Check the select key result class.");
                    resultClass = Resources.classForName(resultClassName);
                } else if (keyPropName != null && parameterClass != null) {
                    resultClass = PROBE.getPropertyTypeForSetter(parameterClass, selectKeyStatement.getKeyProperty());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SqlMapException("Error.  Could not set result class.  Cause: " + e, e);
            }
            if (resultClass == null) {
                resultClass = Object.class;
            }
        } else {
            throw new SqlMapException("You cant set a select key statement on statement named " + this.rootStatement.getId() + " because it is not an InsertStatement.");
        }
        this.errorContext.setMoreInfo("Check the select key SQL statement.");
        Sql sql = processor.getSql();
        selectKeyStatement.setGeneratedKeys(genKey);
        this.setSqlForStatement(selectKeyStatement, sql);
        AutoResultMap resultMap = new AutoResultMap(this.client.getDelegate(), false);
        resultMap.setId(selectKeyStatement.getId() + "-AutoResultMap");
        resultMap.setResultClass(resultClass);
        resultMap.setResource(selectKeyStatement.getResource());
        selectKeyStatement.setResultMap(resultMap);
        this.errorContext.setMoreInfo(null);
        insertStatement.setSelectKeyStatement(selectKeyStatement);
    }

    private void setSqlForStatement(MappedStatement statement, Sql sql) {
        if (sql instanceof DynamicSql) {
            statement.setSql(sql);
        } else {
            this.applyInlineParameterMap(statement, sql.getSql(null, null));
        }
    }

    private void applyInlineParameterMap(MappedStatement statement, String sqlStatement) {
        String newSql = sqlStatement;
        this.errorContext.setActivity("building an inline parameter map");
        ParameterMap parameterMap = statement.getParameterMap();
        this.errorContext.setMoreInfo("Check the inline parameters.");
        if (parameterMap == null) {
            ParameterMap map = new ParameterMap(this.client.getDelegate());
            map.setId(statement.getId() + "-InlineParameterMap");
            map.setParameterClass(statement.getParameterClass());
            map.setResource(statement.getResource());
            statement.setParameterMap(map);
            SqlText sqlText = PARAM_PARSER.parseInlineParameterMap(this.client.getDelegate().getTypeHandlerFactory(), newSql, statement.getParameterClass());
            newSql = sqlText.getText();
            List<ParameterMapping> mappingList = Arrays.asList(sqlText.getParameterMappings());
            map.setParameterMappingList(mappingList);
        }
        Sql sql = SimpleDynamicSql.isSimpleDynamicSql(newSql) ? new SimpleDynamicSql(this.client.getDelegate(), newSql) : new StaticSql(newSql);
        statement.setSql(sql);
    }

    private ResultMap buildAutoResultMap(boolean allowRemapping, MappedStatement statement, Class<?> firstResultClass) {
        AutoResultMap resultMap = new AutoResultMap(this.client.getDelegate(), allowRemapping);
        resultMap.setId(statement.getId() + "-AutoResultMap");
        resultMap.setResultClass(firstResultClass);
        resultMap.setResource(statement.getResource());
        return resultMap;
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public void addFlushEntityCache(Class<?> entityClass) {
        this.mappedStatement.addFlushEntityCache(entityClass);
    }

    public void addFlushCacheModel(String cacheModel) {
        this.mappedStatement.addFlushCacheModel(cacheModel);
    }

    public void addFlushCacheRoot(String name) {
        this.mappedStatement.addFlushCacheRoot(name);
    }
}

