/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.config;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.config.CacheModelConfig;
import com.ibatis.sqlmap.engine.config.MappedStatementConfig;
import com.ibatis.sqlmap.engine.config.ParameterMapConfig;
import com.ibatis.sqlmap.engine.config.ResultMapConfig;
import com.ibatis.sqlmap.engine.config.SqlSource;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.Map;
import org.ibatis.cglib.ClassInfo;

public class SqlMapConfiguration {
    static final ILog log = ILogFactory.getLog(SqlMapConfiguration.class.getPackage().getName());
    private static final Probe PROBE = ProbeFactory.getProbe();
    private ErrorContext errorContext = new ErrorContext();
    private SqlMapExecutorDelegate delegate;
    private TypeHandlerFactory typeHandlerFactory;
    private SqlMapClientImpl client;
    private Integer defaultStatementTimeout;

    public SqlMapConfiguration(XmlParserState state) {
        this.delegate = new SqlMapExecutorDelegate(state);
        this.typeHandlerFactory = this.delegate.getTypeHandlerFactory();
        this.client = new SqlMapClientImpl(this.delegate);
        this.registerDefaultTypeAliases();
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public ErrorContext getErrorContext() {
        return this.errorContext;
    }

    public SqlMapClientImpl getClient() {
        return this.client;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public void setClassInfoCacheEnabled(boolean classInfoCacheEnabled) {
        this.errorContext.setActivity("setting class info cache enabled/disabled");
        ClassInfo.setCacheEnabled(classInfoCacheEnabled);
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.errorContext.setActivity("setting lazy loading enabled/disabled");
        this.client.getDelegate().setLazyLoadingEnabled(lazyLoadingEnabled);
    }

    public void setStatementCachingEnabled(boolean statementCachingEnabled) {
        this.errorContext.setActivity("setting statement caching enabled/disabled");
        this.client.getDelegate().setStatementCacheEnabled(statementCachingEnabled);
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.errorContext.setActivity("setting cache models enabled/disabled");
        this.client.getDelegate().setCacheModelsEnabled(cacheModelsEnabled);
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.errorContext.setActivity("setting enhancement enabled/disabled");
        this.client.getDelegate().setEnhancementEnabled(enhancementEnabled);
        AccessPlanFactory.setBytecodeEnhancementEnabled(enhancementEnabled);
    }

    public void setDatabasePagingQueryEnabled(boolean databasePagingQueryEnabled) {
        this.errorContext.setActivity("setting database paging query enabled/disabled");
        this.client.getDelegate().setDatabasePagingQueryEnabled(databasePagingQueryEnabled);
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.client.getDelegate().setUseColumnLabel(useColumnLabel);
    }

    public void setJdbcTypeForNull(Integer jdbcTypeForNull) {
        this.client.getDelegate().setJdbcTypeForNull(jdbcTypeForNull);
    }

    public void setForceCacheModelType(String forceCacheModelType) {
        this.client.getDelegate().setForceCacheModelType(forceCacheModelType);
    }

    public void setDefaultCacheModelType(String defaultCacheModelType) {
        this.client.getDelegate().setDefaultCacheModelType(defaultCacheModelType);
    }

    public void setForceMultipleResultSetSupport(boolean forceMultipleResultSetSupport) {
        this.client.getDelegate().setForceMultipleResultSetSupport(forceMultipleResultSetSupport);
    }

    public void setDefaultStatementTimeout(String defaultTimeout) {
        this.errorContext.setActivity("setting default timeout");
        if (defaultTimeout != null) {
            try {
                this.defaultStatementTimeout = Integer.valueOf(defaultTimeout);
            }
            catch (NumberFormatException e) {
                throw new SqlMapException("Specified defaultStatementTimeout '" + defaultTimeout + "' is not a valid integer");
            }
        }
    }

    public void setTransactionManager(TransactionManager txManager) {
        this.delegate.setTxManager(txManager);
    }

    public void setResultObjectFactory(ResultObjectFactory rof) {
        this.delegate.setResultObjectFactory(rof);
    }

    public void newTypeHandler(Class<?> javaType, String jdbcType, Object callback) {
        try {
            TypeHandler<Object> typeHandler;
            this.errorContext.setActivity("building a building custom type handler");
            TypeHandlerFactory typeHandlerFactory = this.client.getDelegate().getTypeHandlerFactory();
            if (callback instanceof TypeHandlerCallback) {
                typeHandler = new CustomTypeHandler((TypeHandlerCallback)callback);
            } else if (callback instanceof TypeHandler) {
                typeHandler = (TypeHandler)callback;
            } else {
                throw new RuntimeException("The object '" + callback + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
            }
            this.errorContext.setMoreInfo("Check the javaType attribute '" + javaType + "' (must be a classname) or the jdbcType '" + jdbcType + "' (must be a JDBC type name).");
            if (jdbcType != null && jdbcType.length() > 0) {
                typeHandlerFactory.register(javaType, jdbcType, typeHandler);
            } else {
                typeHandlerFactory.register(javaType, typeHandler);
            }
        }
        catch (Exception e) {
            throw new SqlMapException("Error registering occurred.  Cause: " + e, e);
        }
        this.errorContext.setMoreInfo(null);
        this.errorContext.setObjectId(null);
    }

    public CacheModelConfig newCacheModelConfig(String id, CacheController controller) {
        return new CacheModelConfig(this, id, controller);
    }

    public ParameterMapConfig newParameterMapConfig(String id, Class<?> parameterClass) {
        return new ParameterMapConfig(this, id, parameterClass);
    }

    public ResultMapConfig newResultMapConfig(String id, Class<?> resultClass, String groupBy, String extended) {
        return new ResultMapConfig(this, id, resultClass, groupBy, extended);
    }

    public MappedStatementConfig newMappedStatementConfig(String id, MappedStatement statement, SqlSource processor, String parameterMapName, Class<?> parameterClass, String resultMapName, String[] additionalResultMapNames, Class<?> resultClass, Class<?>[] additionalResultClasses, String resultSetType, Integer fetchSize, boolean allowRemapping, Integer timeout, String cacheModelName, boolean canBatch) {
        return new MappedStatementConfig(this, id, statement, processor, parameterMapName, parameterClass, resultMapName, additionalResultMapNames, resultClass, additionalResultClasses, cacheModelName, resultSetType, fetchSize, allowRemapping, timeout, this.defaultStatementTimeout, canBatch);
    }

    public void finalizeSqlMapConfig() {
        this.delegate.finalizeSqlMapConfig();
    }

    TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class<?> clazz, String propertyName, Class<?> javaType, String jdbcType) {
        return this.resolveTypeHandler(typeHandlerFactory, clazz, propertyName, javaType, jdbcType, false);
    }

    TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class<?> clazz, String propertyName, Class<?> javaType, String jdbcType, boolean useSetterToResolve) {
        TypeHandler<Object> handler;
        if (clazz == null) {
            handler = typeHandlerFactory.getUnkownTypeHandler();
        } else if (Map.class.isAssignableFrom(clazz)) {
            handler = javaType == null ? typeHandlerFactory.getUnkownTypeHandler() : typeHandlerFactory.getTypeHandler(javaType, jdbcType);
        } else if (typeHandlerFactory.getTypeHandler(clazz, jdbcType) != null) {
            handler = typeHandlerFactory.getTypeHandler(clazz, jdbcType);
        } else if (javaType == null) {
            if (useSetterToResolve) {
                Class<?> type = PROBE.getPropertyTypeForSetter(clazz, propertyName);
                handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
            } else {
                Class<?> type = PROBE.getPropertyTypeForGetter(clazz, propertyName);
                handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
            }
        } else {
            handler = typeHandlerFactory.getTypeHandler(javaType, jdbcType);
        }
        return handler;
    }

    private void registerDefaultTypeAliases() {
        this.typeHandlerFactory.putTypeAlias("JDBC", "com.ibatis.sqlmap.engine.transaction.jdbc.JdbcTransactionConfig");
        this.typeHandlerFactory.putTypeAlias("JTA", "com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig");
        this.typeHandlerFactory.putTypeAlias("EXTERNAL", "com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig");
        this.typeHandlerFactory.putTypeAlias("SIMPLE", "com.ibatis.sqlmap.engine.datasource.SimpleDataSourceFactory");
        this.typeHandlerFactory.putTypeAlias("DBCP", "com.ibatis.sqlmap.engine.datasource.DbcpDataSourceFactory");
        this.typeHandlerFactory.putTypeAlias("JNDI", "com.ibatis.sqlmap.engine.datasource.JndiDataSourceFactory");
        this.typeHandlerFactory.putTypeAlias("FIFO", "com.ibatis.sqlmap.engine.cache.fifo.FifoCacheController");
        this.typeHandlerFactory.putTypeAlias("LRU", "com.ibatis.sqlmap.engine.cache.lru.LruCacheController");
        this.typeHandlerFactory.putTypeAlias("MEMORY", "com.ibatis.sqlmap.engine.cache.memory.MemoryCacheController");
        this.typeHandlerFactory.putTypeAlias("OSCACHE", "com.ibatis.sqlmap.engine.cache.oscache.OSCacheController");
        this.typeHandlerFactory.putTypeAlias("EHCACHE", "com.ibatis.sqlmap.engine.cache.ehcache.EhCacheController");
    }

    public String toCacheModelType(String type) {
        return this.getDelegate().toCacheModelType(type);
    }
}

