/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.dialect;

import com.ibatis.sqlmap.client.lexer.SqlLexer;
import com.ibatis.sqlmap.client.lexer.TT;
import com.ibatis.sqlmap.client.lexer.Token;
import com.ibatis.sqlmap.engine.dialect.PageDialect;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import org.ibatis.client.Dialect;

public class LimitOffsetPageDialect
implements PageDialect {
    final Dialect dialect;
    final SqlLexer parser;
    boolean count;
    int skip;
    int max;
    static final TT[] kws = new TT[]{TT.Select, TT.Order, TT.Limit};

    public LimitOffsetPageDialect(Dialect d, String sql, boolean count, int skip, int max) {
        this.dialect = d;
        this.parser = new SqlLexer(sql, kws);
        this.count = count;
        this.skip = skip;
        this.max = max;
    }

    @Override
    public PageDialect canHandle(String productNameLowerCase, int majorVersion, int minorVersion) {
        if (this.dialect == Dialect.db2 && (majorVersion < 9 || minorVersion < 7)) {
            return null;
        }
        Token t = this.parser.firstKeyword();
        if (t == null || t.type != TT.Select) {
            return null;
        }
        if (this.parser.indexOf(TT.Limit) == -1) {
            return this;
        }
        if (this.parser.topLastIndexOf(TT.Limit) == -1) {
            return this;
        }
        return null;
    }

    @Override
    public String getPageSql(ErrorContext ec) {
        StringBuilder buf = new StringBuilder();
        buf.append(" LIMIT ").append(this.max);
        if (this.skip > 0) {
            buf.append(" OFFSET ").append(this.skip);
        }
        String add = buf.toString();
        String sql = this.parser.getSql() + add;
        if (ec.getSql() == null) {
            ec.setSql(sql);
        } else {
            ec.setSql(ec.getSql() + add);
        }
        return sql;
    }

    @Override
    public String getCountSql(ErrorContext ec) {
        int oIdx = this.parser.topLastIndexOf(TT.Order);
        if (oIdx == -1 || this.parser.topIndexOf(TT.Question, oIdx + 1) > 0) {
            ec.setExtraSql("select count(1) from (...) _jbatis_tmp_cnt_");
            return "select count(1) from (" + this.parser.getSql() + ") _jbatis_tmp_cnt_";
        }
        Token ot = this.parser.getCascadeTokens().get(oIdx);
        ec.setExtraSql("select count(1) from (.. -< " + this.parser.getSql().substring(ot.offset) + ") _jbatis_tmp_cnt_");
        return "select count(1) from (" + this.parser.getSql().substring(0, ot.offset) + ") _jbatis_tmp_cnt_";
    }
}

