/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.dialect;

import com.ibatis.sqlmap.client.lexer.SqlLexer;
import com.ibatis.sqlmap.client.lexer.TT;
import com.ibatis.sqlmap.client.lexer.Token;
import com.ibatis.sqlmap.engine.dialect.PageDialect;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import org.ibatis.client.Dialect;

public class OffsetFetchPageDialect
implements PageDialect {
    final Dialect dialect;
    final SqlLexer parser;
    boolean count;
    int skip;
    int max;
    static final TT[] kws1 = new TT[]{TT.Select, TT.Top, TT.Order, TT.Offset};
    static final TT[] kws2 = new TT[]{TT.Select, TT.Top, TT.Offset, TT.Fetch, TT.Update};

    public OffsetFetchPageDialect(Dialect d, String sql, boolean count, int skip, int max) {
        this.dialect = d;
        this.parser = this.dialect == Dialect.sqlserver ? new SqlLexer(sql, kws1) : new SqlLexer(sql, kws2);
        this.count = count;
        this.skip = skip;
        this.max = max;
    }

    @Override
    public PageDialect canHandle(String productNameLowerCase, int majorVersion, int minorVersion) {
        Token t;
        if (this.dialect == Dialect.sqlserver) {
            if (majorVersion < 11) {
                return null;
            }
        } else if (this.dialect == Dialect.oracle) {
            if (majorVersion < 12) {
                return null;
            }
        } else {
            return null;
        }
        if ((t = this.parser.firstKeyword()) == null || t.type != TT.Select) {
            return null;
        }
        if (this.parser.topIndexOf(TT.Top) > 0) {
            return null;
        }
        if (this.dialect == Dialect.sqlserver) {
            int oIdx = this.parser.topLastIndexOf(TT.Order);
            if (oIdx < 0) {
                return null;
            }
            if (this.parser.topIndexOf(TT.Offset, oIdx) > 0) {
                return null;
            }
        }
        if (this.dialect == Dialect.oracle) {
            if (this.parser.topLastIndexOf(TT.Offset) > 0) {
                return null;
            }
            if (this.parser.topLastIndexOf(TT.Fetch) > 0) {
                return null;
            }
            if (this.parser.topLastIndexOf(TT.Update) > 0) {
                return null;
            }
        }
        return this;
    }

    @Override
    public String getPageSql(ErrorContext ec) {
        StringBuilder buf = new StringBuilder();
        if (this.skip < 0) {
            this.skip = 0;
        }
        buf.append(" OFFSET ").append(this.skip).append(" ROWS");
        buf.append(" FETCH NEXT ").append(this.max).append(" ROWS ONLY");
        String add = buf.toString();
        String sql = this.parser.getSql() + add;
        if (ec.getSql() == null) {
            ec.setSql(sql);
        } else {
            ec.setSql(ec.getSql() + add);
        }
        return sql;
    }

    @Override
    public String getCountSql(ErrorContext ec) {
        int oIdx = this.parser.topLastIndexOf(TT.Order);
        if (this.dialect == Dialect.oracle) {
            if (oIdx == -1 || this.parser.topIndexOf(TT.Question, oIdx + 1) > 0) {
                ec.setExtraSql("select count(1) from (...)");
                return "select count(1) from (" + this.parser.getSql() + ")";
            }
            Token ot = this.parser.getCascadeTokens().get(oIdx);
            ec.setExtraSql("select count(1) from (.. -< " + this.parser.getSql().substring(ot.offset) + ")");
            return "select count(1) from (" + this.parser.getSql().substring(0, ot.offset) + ")";
        }
        if (oIdx == -1 || this.parser.topIndexOf(TT.Question, oIdx + 1) > 0) {
            ec.setExtraSql("select count(1) from (...) _jbatis_tmp_cnt_");
            return "select count(1) from (" + this.parser.getSql() + ") _jbatis_tmp_cnt_";
        }
        Token ot = this.parser.getCascadeTokens().get(oIdx);
        ec.setExtraSql("select count(1) from (.. -< " + this.parser.getSql().substring(ot.offset) + ") _jbatis_tmp_cnt_");
        return "select count(1) from (" + this.parser.getSql().substring(0, ot.offset) + ") _jbatis_tmp_cnt_";
    }
}

