/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.common.Objects;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.DefaultSqlExecutor;
import com.ibatis.sqlmap.engine.execution.ExecuteNotifier;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Batch {
    final boolean debug;
    private boolean cleanup;
    private Map<Object, BatchResult> batchResultList = new LinkedHashMap<Object, BatchResult>();
    private int totalSize;
    private int totalRows;
    final int batchSize;
    private Map<ExecuteNotifier, String> statementSqls = new HashMap<ExecuteNotifier, String>();

    public String toString() {
        return "Batch total size: " + this.totalSize + ", total affected rows: " + this.totalRows + ", sql count: " + this.batchResultList.size();
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public Batch(int batchSize, boolean debug) {
        this.debug = debug;
        this.batchSize = batchSize;
        this.totalSize = 0;
    }

    public int getSize() {
        return this.totalSize;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void addBatch(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        PreparedStatement ps;
        MappedStatement ms = statementScope.getStatement();
        boolean isCall = ms.getStatementType() == StatementType.PROCEDURE;
        this.statementSqls.put(ms, sql);
        Object key = Objects.getKey(ms.getId(), sql);
        BatchResult br = this.batchResultList.get(key);
        if (br == null) {
            br = new BatchResult(this.batchSize, sql, statementScope.getErrorContext());
            this.batchResultList.put(key, br);
        }
        if ((ps = br.getPreparedStatement()) == null) {
            ps = isCall ? DefaultSqlExecutor.prepareCall(statementScope.getSession(), conn, sql) : DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, false);
            DefaultSqlExecutor.setStatementTimeout(ms, ps);
            br.setPreparedStatement(ps);
        }
        Object[] args = statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
        ps.addBatch();
        ++br.total;
        br.addArgs(args);
        ++this.totalSize;
    }

    public int executeBatch() throws SQLException {
        int totalRowCount = 0;
        for (BatchResult br : this.batchResultList.values()) {
            PreparedStatement ps = br.getPreparedStatement();
            int[] rowCounts = null;
            try {
                rowCounts = ps.executeBatch();
            }
            catch (BatchUpdateException e) {
                ErrorContext ec = br.getErrorContext();
                ec.setCause(e);
                int[] uc = e.getUpdateCounts();
                if (uc != null) {
                    if (uc.length == br.total) {
                        int i;
                        for (i = 0; i < uc.length && uc[i] != -3; ++i) {
                        }
                        ec.setArgs(br.getArgs(i));
                        ec.setBatchInfo("Batch failed at: " + (i + 1) + " of " + br.total);
                    } else {
                        ec.setArgs(br.getArgs(uc.length));
                        ec.setBatchInfo("Batch failed at: " + (uc.length + 1) + " of " + br.total);
                    }
                } else {
                    ec.setArgs(br.getArgs(-1));
                    ec.setBatchInfo("Batch error: total = " + br.total);
                }
                throw new NestedSQLException(ec.toString(), e.getSQLState(), e.getErrorCode(), e);
            }
            int rows = 0;
            for (int j = 0; j < rowCounts.length; ++j) {
                if (rowCounts[j] == -2) continue;
                if (rowCounts[j] == -3) {
                    ErrorContext ec = br.getErrorContext();
                    ec.setBatchInfo("Batch failed: " + (j + 1) + " of " + br.total);
                    ec.setArgs(br.getArgs(j));
                    ec.setCause("The batched statement: " + (j + 1) + " failed to execute.");
                    throw new SQLException(ec.toString());
                }
                rows += rowCounts[j];
                totalRowCount += rowCounts[j];
            }
            br.totalRows = rows;
        }
        this.totalRows = totalRowCount;
        return totalRowCount;
    }

    public List<BatchResult> executeBatchDetailed() throws SQLException, BatchException {
        ArrayList<BatchResult> answer = new ArrayList<BatchResult>();
        int totalRowCount = 0;
        int i = 0;
        for (BatchResult br : this.batchResultList.values()) {
            PreparedStatement ps = br.getPreparedStatement();
            try {
                br.setUpdateCounts(ps.executeBatch());
            }
            catch (BatchUpdateException e) {
                ErrorContext ec = br.getErrorContext();
                ec.setCause(e);
                int[] uc = e.getUpdateCounts();
                if (uc != null) {
                    if (uc.length == br.total) {
                        int j;
                        for (j = 0; j < uc.length && uc[i] != -3; ++j) {
                        }
                        ec.setArgs(br.getArgs(i));
                        ec.setBatchInfo("Batch(" + (i + 1) + ") failed at: " + (j + 1) + " of " + br.total);
                    } else {
                        ec.setArgs(br.getArgs(uc.length));
                        ec.setBatchInfo("Batch(" + (i + 1) + ") failed at: " + (uc.length + 1) + " of " + br.total);
                    }
                } else {
                    ec.setArgs(br.getArgs(-1));
                    ec.setBatchInfo("Batch(" + (i + 1) + ") error: total = " + br.total);
                }
                throw new BatchException(ec.toString(), e, answer, br.getStatementId(), br.getSql());
            }
            int rows = 0;
            int[] rowCounts = br.getUpdateCounts();
            for (int j = 0; j < rowCounts.length; ++j) {
                if (rowCounts[j] == -2 || rowCounts[j] == -3) continue;
                rows += rowCounts[j];
                totalRowCount += rowCounts[j];
            }
            br.totalRows = rows;
            answer.add(br);
            ++i;
        }
        this.totalRows = totalRowCount;
        return answer;
    }

    public boolean hasNotifier(ExecuteNotifier en) {
        return this.statementSqls != null && this.statementSqls.containsKey(en);
    }

    public void cleanupBatch(SessionScope sessionScope) {
        this.cleanup = true;
        for (BatchResult br : this.batchResultList.values()) {
            DefaultSqlExecutor.closeStatement(sessionScope, br.getPreparedStatement());
            br.setPreparedStatement(null);
        }
        if (!this.debug) {
            this.batchResultList.clear();
        }
        if (this.statementSqls != null) {
            Long timestamp = System.currentTimeMillis();
            for (ExecuteNotifier en : this.statementSqls.keySet()) {
                en.notifyListeners(timestamp);
            }
            if (!this.debug) {
                this.statementSqls.clear();
                this.statementSqls = null;
            }
        }
    }

    public List<ErrorContext> popErrorContexts() {
        ArrayList<ErrorContext> list = new ArrayList<ErrorContext>();
        for (BatchResult br : this.batchResultList.values()) {
            ErrorContext ec = br.getErrorContext();
            ec.setBatchInfo("Batch size: " + br.total + ", affected rows: " + br.totalRows);
            ec.setArgs(br.getArgs(-1));
            list.add(ec);
        }
        this.batchResultList.clear();
        return list;
    }

    public Map<ExecuteNotifier, String> popBatchedMap() {
        Map<ExecuteNotifier, String> ret = this.statementSqls;
        this.statementSqls = null;
        return ret;
    }
}

